% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockdyn-methods.R
\name{plot,DeponsBlockdyn,missing-method}
\alias{plot,DeponsBlockdyn,missing-method}
\alias{plot.DeponsBlockdyn}
\title{Plot a DeponsBlockdyn object}
\usage{
\S4method{plot}{DeponsBlockdyn,missing}(x, y, dilute = 5, ...)
}
\arguments{
\item{x}{DeponsBlockdyn object}

\item{y}{Not used}

\item{dilute}{Integer. Plot only one in every 'dilute' values. Defaults to
5, which yields a plot of the first simulated value and one in every five of
the following values.}

\item{...}{Optional plotting parameters}
}
\value{
\code{data.frame} listing blocks where no animals were counted
(returned invisibly)
}
\description{
Plot population dynamics simulated with DEPONS
}
\note{
The function returns a data frame with numbers of blocks with no agents.
}
\examples{
data("porpoisebdyn")
my.col <- c("red", "darkgreen", "orange")
plot(porpoisebdyn, col=my.col)
legend("bottomright", bty="n", fill=my.col, legend=paste("Block", 0:2))

# Show all data points for small range of x-values
plot(porpoisebdyn, xlim=c(1950, 2050), ylim=c(4850, 5050), type="p", dilute=1, col=my.col)
}
