% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyt_volc.R
\name{cyt_volc}
\alias{cyt_volc}
\title{Volcano Plot.}
\usage{
cyt_volc(
  data,
  group_col,
  cond1 = NULL,
  cond2 = NULL,
  fold_change_thresh = 2,
  p_value_thresh = 0.05,
  top_labels = 10,
  verbose = FALSE
)
}
\arguments{
\item{data}{A matrix or data frame containing the data to be analyzed.}

\item{group_col}{A character string specifying the column name used for
comparisons (e.g., group, treatment, or stimulation).}

\item{cond1}{A character string specifying the name of the first condition
for comparison. Default is \code{NULL}.}

\item{cond2}{A character string specifying the name of the second condition
for comparison. Default is \code{NULL}.}

\item{fold_change_thresh}{A numeric threshold for the fold change.
Default is \code{2}.}

\item{p_value_thresh}{A numeric threshold for the p-value.
Default is \code{0.05}.}

\item{top_labels}{An integer specifying the number of top variables to label
on the plot. Default is \code{10}.}

\item{verbose}{A logical indicating whether to print the computed statistics
to the console. Default is \code{FALSE}.}
}
\value{
A list of volcano plots (as \code{ggplot} objects) for each pairwise
comparison. Additionally, the function prints the data frame used for
plotting (excluding the significance column) from the final comparison.
}
\description{
This function subsets the numeric columns from the input data
and compares them based on a selected grouping column. It computes the fold
changes (as the ratio of means) and associated p-values (using two-sample
t-tests) for each numeric variable between two groups. The results are
log2-transformed (for fold change) and -log10-transformed (for p-values)
to generate a volcano plot.
}
\note{
If \code{cond1} and \code{cond2} are not provided, the function
automatically generates all possible pairwise combinations of groups from
the specified \code{group_col} for comparisons.
}
\examples{
# Loading data
data_df <- ExampleData1[,-c(2:3)]

volc_plot <- cyt_volc(data_df, "Group", cond1 = "T2D", cond2 = "ND",
fold_change_thresh = 2.0, top_labels= 15)
print(volc_plot$`T2D vs ND`)
}
\author{
Xiaohua Douglas Zhang and Shubh Saraswat
}
