% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cms_login.r
\name{cms_get_username}
\alias{cms_get_username}
\alias{cms_get_password}
\alias{cms_set_username}
\alias{cms_set_password}
\title{Set or get Copernicus account details}
\usage{
cms_get_username()

cms_get_password()

cms_set_username(username, method = c("option", "sysenv"))

cms_set_password(password, method = c("option", "sysenv"))
}
\arguments{
\item{username}{Your Copernicus Marine username}

\item{method}{Either \code{"option"} to use R options to store account details.
Use \code{"sysenv"} to store account details as system environment variable.}

\item{password}{Your Copernicus Marine password}
}
\value{
Returns your account details for the \code{get} variant or nothing in case
of the \code{set} variant.
}
\description{
Set or get username and password throughout an R session.
This can be used to obscure your account details in an R script and
store them as either an R option or system environment variable.
}
\examples{
if (interactive()) {
  ## Returns your account details only if they have been set for your session
  cms_get_username()
  cms_get_password()
}
}
\author{
Pepijn de Vries
}
