% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyplot.R
\name{polyplot}
\alias{polyplot}
\title{Plot rankings on a permutation polytope of 3 o 4 objects containing all possible ties}
\usage{
polyplot(X = NULL, L = NULL, Wk = NULL, nobj = 3)
}
\arguments{
\item{X}{the sample of rankings. Most of the time it is returned by tabulaterows}

\item{L}{labels of the objects}

\item{Wk}{frequency associated to each ranking}

\item{nobj}{number of objects. It must be either 3 or 4}
}
\value{
the permutation polytope
}
\description{
Plot rankings a permutation polytope that is the geometrical space of preference rankings. The plot is available for 3 or for 4 objects
}
\details{
polyplot() plots the universe of 3 objects. polyplot(nobj=4) plots the universe of 4 objects.
Note: 4-object plots require the 'rgl' package to be installed.
}
\examples{
\dontrun{
polyplot()
}

\dontrun{
# Requires rgl package
polyplot(nobj=4)
data(BU)
polyplot(BU[,1:3],Wk=BU[,4])
}

}
\references{
Thompson, G. L. (1993). Generalized permutation polytopes and exploratory graphical methods for ranked data. The Annals of Statistics, 1401-1430.
#
Heiser, W. J., and D'Ambrosio, A. (2013). Clustering and prediction of rankings within a Kemeny distance framework. In Algorithms from and for Nature and Life (pp. 19-31). Springer International Publishing.
}
\seealso{
\code{\link{tabulaterows}} frequency distribution for ranking data.
}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it} and Sonia Amodio \email{sonia.amodio@unina.it}
}
\keyword{Permutation}
\keyword{polytope}
