% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SubsetDefinitions.R
\name{createCohortSubsetDefinition}
\alias{createCohortSubsetDefinition}
\title{Create Subset Definition}
\usage{
createCohortSubsetDefinition(
  name,
  definitionId,
  subsetOperators,
  identifierExpression = NULL,
  operatorNameConcatString = "",
  subsetCohortNameTemplate = ""
)
}
\arguments{
\item{name}{Name of definition}

\item{definitionId}{Definition identifier}

\item{subsetOperators}{list of subsetOperator instances to apply}

\item{identifierExpression}{Expression (or string that converts to expression) that returns an id for an output cohort
the default is dplyr::expr(targetId * 1000 + definitionId)}

\item{operatorNameConcatString}{(optional) String to concatenate operator names together when outputting resulting cohort
name}

\item{subsetCohortNameTemplate}{(optional) SqlRender string template for formatting names of resulting subset cohorts
Can use the variables @baseCohortName, @subsetDefinitionName and @operatorNames.
This is applied when adding the subset definition to a cohort definition set.}
}
\description{
Create subset definition from subset objects
}
