% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FanPC_CoFM.R
\name{FanPC_CoFM}
\alias{FanPC_CoFM}
\title{Perform Factor Analysis via Principal Component (FanPC) for CoFM}
\usage{
FanPC_CoFM(data, m, A, D)
}
\arguments{
\item{data}{A matrix or data frame of input data (n x p). Usually the \code{$data}
output from \code{CoFM}.}

\item{m}{Integer. The number of principal components (factors) to extract.}

\item{A}{Matrix. The true factor loadings matrix (p x m). Usually \code{$True_Params$A}
from \code{CoFM}.}

\item{D}{Matrix. The true uniquenesses matrix (p x p). Usually \code{$True_Params$D}
from \code{CoFM}.}
}
\value{
A list containing:
\item{AF}{Estimated factor loadings matrix (p x m).}
\item{DF}{Estimated uniquenesses matrix (p x p).}
\item{MSESigmaA}{Mean Squared Error for factor loadings.}
\item{MSESigmaD}{Mean Squared Error for uniquenesses.}
\item{LSigmaA}{Relative loss metric for factor loadings.}
\item{LSigmaD}{Relative loss metric for uniquenesses.}
}
\description{
This function estimates factor loadings and uniquenesses using a principal-component
(FanPC) approach. It then compares these estimates with the true parameters (A and D)
to calculate Mean Squared Errors (MSE) and relative loss metrics. This is designed to
work with data generated by the \code{\link{CoFM}} function.
}
\examples{
# Examples should be fast and reproducible for CRAN checks
set.seed(123)

# 1. Generate toy data using CoFM
sim_result <- CoFM(n = 200, p = 6, m = 2, type = "Clayton", param = 2.0)

# 2. Extract true parameters and observed data
true_A <- sim_result$True_Params$A
true_D <- sim_result$True_Params$D
obs_data <- sim_result$data

# 3. Apply FanPC and compute error metrics
fanpc_result <- FanPC_CoFM(data = obs_data, m = 2, A = true_A, D = true_D)

# 4. Inspect results
fanpc_result$MSESigmaA
fanpc_result$MSESigmaD
head(fanpc_result$AF)
}
