% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{diffmeans_sumvariance_plot}
\alias{diffmeans_sumvariance_plot}
\title{Creates the old version of the difference in means by sum of variances plot}
\usage{
diffmeans_sumvariance_plot(
  data,
  xcol = "diff_means",
  ycol = "sum_variance",
  feature_id_col = "id",
  is_feature_selected_col = NULL,
  label_var1 = "Target",
  label_var2 = "Others",
  target_vector = NULL,
  mean_cutoff = NULL,
  var_cutoff = NULL,
  threshold_func = NULL,
  func_factor = NULL,
  feats_to_highlight = NULL,
  cpg_ranking_df = NULL,
  color_all_points = NULL,
  plot_density = TRUE,
  density_type = c("density", "histogram", "boxplot", "violin", "densigram"),
  plot_dir = NULL,
  id_tag = NULL,
  file_tag = NULL,
  custom_mods = FALSE
)
}
\arguments{
\item{data}{Data to create difference in means, sum of variances plot.
Either a data.frame with `xcol`,`ycol` and `feature_id_col` or, if
`target_vector` is not `NULL` a matrix with beta values from which,
given the target, the difference in means between the target and others,
and the sum of variances within the target and others will be calculated.}

\item{xcol}{Column with x-axis data}

\item{ycol}{Column with y-axis data}

\item{feature_id_col}{Column with the feature ID}

\item{is_feature_selected_col}{NULL or column with TRUE/FALSE for features which should be highlighted as selected}

\item{label_var1}{Label of the target class}

\item{label_var2}{Label of the other classes}

\item{target_vector}{if not NULL a vector target class assignment, see data}

\item{mean_cutoff}{a numeric draw mean cutoff at given position}

\item{var_cutoff}{a numeric draw variance cutoff at given position}

\item{threshold_func}{specification of the parabola function, see examples}

\item{func_factor}{argument to be passed to the parabola function, see examples}

\item{feats_to_highlight}{features (CpGs) to be highlighted in the plot}

\item{cpg_ranking_df}{data.frame with ranked features (CpGs) to be highlighted in the plot, if present must have the following columns: .id, predType, Rank and DiffAndFoldScaledAUPR}

\item{color_all_points}{color that all non-highlighted points should have, argument defaults to NULL, the default color is black}

\item{plot_density}{A boolean, if TRUE (default) the function will produce density plots on top/side of scatterplot}

\item{density_type}{One of "density", "histogram", "boxplot", "violin" or "densigram". Defines the type of density plot if `plot_density = TRUE`}

\item{plot_dir}{path to directory where to save the plot. If NULL (default), plot will not be saved.}

\item{id_tag}{character string to identify plots, is displayed in the plot and present in the file name}

\item{file_tag}{character string to identify plots, tags only the file name}

\item{custom_mods}{a boolean, if TRUE will add some custom labels to the plot. Default is FALSE}
}
\value{
a \code{ggplot2} object with the dmsv plot.
}
\description{
Represent CpGs in the difference in means, sum of variances space.
This plot is often used to select CpGs that would be good classifiers.
These CpGs are often located on the bottom left and
bottom right of this plot.
}
\examples{
library("CimpleG")

# read data
data(train_data)
data(train_targets)

# make basic plot
plt <- diffmeans_sumvariance_plot(
  train_data,
  target_vector = train_targets$blood_cells == 1
)
print(plt)

# make plot with parabola, colored and highlighted features
df_dmeansvar <- compute_diffmeans_sumvar(
  train_data,
  target_vector = train_targets$blood_cells==1
)
parab_param <- .7
df_dmeansvar$is_selected <- select_features(
    x = df_dmeansvar$diff_means,
    y = df_dmeansvar$sum_variance,
    a = parab_param
)

plt <- diffmeans_sumvariance_plot(
  data=df_dmeansvar,
  label_var1="Leukocytes",
  color_all_points="red",
  is_feature_selected_col="is_selected",
  feats_to_highlight=c("cg10456121"),
  threshold_func=function(x,a) (a*x)^2,
  func_factor=parab_param
)
print(plt)
}
