% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkindirectmodel.R
\name{pkindirectmodel}
\alias{pkindirectmodel}
\title{Create a PK/Indirect response model}
\usage{
pkindirectmodel(
  isPopulation = TRUE,
  parameterization = "Clearance",
  absorption = "Intravenous",
  numCompartments = 1,
  isClosedForm = TRUE,
  isTlag = FALSE,
  hasEliminationComp = FALSE,
  isFractionExcreted = FALSE,
  isSaturating = FALSE,
  infusionAllowed = FALSE,
  isDuration = FALSE,
  isSequential = FALSE,
  isPkFrozen = FALSE,
  hasEffectsCompartment = FALSE,
  indirectType = "LimitedStimulation",
  isBuildup = TRUE,
  isExponent = FALSE,
  indirectFrozen = FALSE,
  data = NULL,
  columnMap = TRUE,
  modelName = "",
  workingDir = "",
  ...
)
}
\arguments{
\item{isPopulation}{Is this a population model \code{TRUE} or individual model \code{FALSE}?}

\item{parameterization}{Type of parameterization. Options are \code{"Clearance"}, \code{"Micro"},
\code{"Macro"}, or \code{"Macro1"}.}

\item{absorption}{Type of absorption. Options are \code{"Intravenous"}, \code{"FirstOrder"},
\code{"Gamma"}, \code{"InverseGaussian"}, \code{"Weibull"} .}

\item{numCompartments}{Value of either  \code{1}, \code{2}, or \code{3}.}

\item{isClosedForm}{Set to \code{TRUE} to convert model from a differential equation to close form.}

\item{isTlag}{Set to \code{TRUE} to add a lag time parameter to the model.}

\item{hasEliminationComp}{Set to \code{TRUE} to add an elimination compartment to the model.}

\item{isFractionExcreted}{Set to \code{TRUE} if elimination compartment (\code{hasEliminationComp = TRUE})
contains a fraction excreted parameter.}

\item{isSaturating}{Set to \code{TRUE} to use Michaelis-Menten kinetics for elimination.
Only applicable to models with \code{paramteterization = "Clearance"}}

\item{infusionAllowed}{Set to \code{TRUE} if infusions allowed.}

\item{isDuration}{Set to \code{TRUE} if infusions use duration instead of rate
(must also set \code{infusionAllowed = TRUE}).}

\item{isSequential}{Set to \code{TRUE} to freeze PK fixed effects and convert
the corresponding random effects into covariates as well as remove the PK observed variable from the model.}

\item{isPkFrozen}{Set to \code{TRUE} to freeze PK fixed effects and remove
the corresponding random effects as well as the PK observed variable from the model.}

\item{hasEffectsCompartment}{Set to \code{TRUE} to include an effect compartment into the model.}

\item{indirectType}{Type of drug actions for the indirect response model.
Options are \code{"LimitedStimulation"}, \code{"InfiniteStimulation"}, \code{"LimitedInhibition"},
\code{"InverseInhibition"}, \code{"LinearStimulation"}, or \code{"LogLinearStimulation"}.}

\item{isBuildup}{Set to \code{FALSE} to have the drug actions affect
the loss/degradation instead of the production.}

\item{isExponent}{Set to \code{TRUE} to add an exponent parameter to the drug action term.}

\item{indirectFrozen}{Set to \code{TRUE} to freeze PD fixed effects and remove
the corresponding random effects as well as the PD observed variable from the model.}

\item{data}{Input dataset}

\item{columnMap}{If \code{TRUE} (default) column mapping arguments are required.
Set to \code{FALSE} to manually map columns after defining model using \code{\link{colMapping}}.}

\item{modelName}{Model name for subdirectory created for model output in current working directory.}

\item{workingDir}{Working directory to run the model. Current working directory will be used
if \code{workingDir} not specified.}

\item{...}{
  Arguments passed on to \code{\link[=pkindirectmodel_MappingParameters]{pkindirectmodel_MappingParameters}}
  \describe{
    \item{\code{ID}}{Column mapping argument for input dataset column(s) that identify
individual data profiles. Only applicable to population models \code{isPopulation = TRUE}.}
    \item{\code{Time}}{Column mapping argument that represents the input dataset column
for the relative time used in a study and only applicable to time-based models.}
    \item{\code{A1}}{Column mapping argument that represents the input dataset column
for the amount of drug administered. Only applicable to the following types of models:
\itemize{
 \item Models with \code{absorption = "Intravenous"} and parameterization set
 to either \code{"Clearance"},\code{"Micro"}, or \code{"Macro"}
 \item Models with \code{absorption} set to either \code{"Gamma"}, \code{"InverseGaussian"},
 or \code{"Weibull"}
 }}
    \item{\code{Aa}}{Column mapping argument that represents the input dataset column
for the amount of drug administered and only applicable to models with \code{absorption = "FirstOrder"}.}
    \item{\code{A}}{Column mapping argument that represents the input dataset column
for the amount of drug administered and only applicable to models with
\code{absorption = "Intravenous"} and \code{parameterization = "Macro1"}.}
    \item{\code{A1_Rate}}{Column mapping argument that represents the input dataset column
for the rate of drug administered.  Only applicable to the following types of models:
\itemize{
 \item Models with \code{absorption = "Intravenous"}, \code{infusionAllowed = TRUE}
 and parameterization set to either \code{"Clearance"},\code{"Micro"} or \code{"Macro"}
 \item Models with \code{absorption} set to either \code{"Gamma"}, \code{"InverseGaussian"},
 or \code{"Weibull"} and \code{infusionAllowed = TRUE}
 }}
    \item{\code{A1_Duration}}{Column mapping argument that represents the input dataset column
for the duration of drug administered.  Only applicable to the following types of models:
\itemize{
 \item Models with \code{absorption = "Intravenous"}, \code{infusionAllowed = TRUE} with
  \code{isDuration = TRUE} and parameterization set to either \code{"Clearance"},\code{"Micro"}
  or \code{"Macro"}
 \item Models with \code{absorption} set to either \code{"Gamma"}, \code{"InverseGaussian"},
 or \code{"Weibull"} and \code{infusionAllowed = TRUE} with \code{isDuration = TRUE}
 }}
    \item{\code{Aa_Rate}}{Column mapping argument that represents the input dataset column
for the rate of drug administered and only applicable to models with \code{absorption = "FirstOrder"},
\code{infusionAllowed = TRUE}.}
    \item{\code{Aa_Duration}}{Column mapping argument that represents the input dataset column
for the duration of drug administered and only applicable to models with \code{absorption = "FirstOrder"},
\code{infusionAllowed = TRUE}, and \code{isDuration = TRUE}.}
    \item{\code{A_Rate}}{Column mapping argument that represents the input dataset column
for the rate of drug administered and only applicable to models with \code{absorption = "Intravenous"},
\code{infusionAllowed = TRUE}, and \code{parameterization = "Macro1"}.}
    \item{\code{A_Duration}}{Column mapping argument that represents the input dataset column
for the duration of drug administered and only applicable to models with \code{absorption = "Intravenous"},
\code{infusionAllowed = TRUE}, \code{isDuration = TRUE}, and \code{parameterization = "Macro1"}.}
    \item{\code{A1Strip}}{Column mapping argument that represents the input dataset column
for the stripping dose and only applicable to models with \code{parameterization = "Macro"}.}
    \item{\code{CObs}}{Column mapping argument that represents the input dataset column
for the observations of drug concentration in the central compartment and only applicable
to models with \code{parameterization} being either set to either \code{"Clearance"} or \code{"Micro"}.}
    \item{\code{C1Obs}}{Column mapping argument that represents the input dataset column
for the observations of drug concentration in the central compartment and only applicable
to models with \code{parameterization} being either set to either \code{"Macro"} or \code{"Macro1"}.}
    \item{\code{A0Obs}}{Column mapping argument that represents the input dataset column
for the observed amount of drug in the elimination compartment. (\code{hasEliminationComp = TRUE}).}
    \item{\code{EObs}}{Column mapping argument that represents the input dataset column
for the observed drug effect.}
    \item{\code{nV}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nV}.}
    \item{\code{nV2}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nV2}.}
    \item{\code{nV3}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nV3}.}
    \item{\code{nCl}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nCl}.}
    \item{\code{nCl2}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nCl2}.}
    \item{\code{nCl3}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nCl3}.}
    \item{\code{nKa}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nKa}.}
    \item{\code{nA}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nA}.}
    \item{\code{nAlpha}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nAlpha}.}
    \item{\code{nB}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nB}.}
    \item{\code{nBeta}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nBeta}.}
    \item{\code{nC}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nC}.}
    \item{\code{nGamma}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nGamma}.}
    \item{\code{nKe}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nKe}.}
    \item{\code{nK12}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nK12}.}
    \item{\code{nK21}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nK21}.}
    \item{\code{nK13}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nK13}.}
    \item{\code{nK31}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nK31}.}
    \item{\code{nTlag}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nTlag}.}
    \item{\code{nKm}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nKm}.}
    \item{\code{nVmax}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nVmax}.}
    \item{\code{nFe}}{If \code{isSequential = TRUE} and \code{isFractionExcreted = TRUE},
mapped to the input dataset column that lists the values for random effect \code{nFe}.}
    \item{\code{nMeanDelayTime}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nMeanDelayTime}.}
    \item{\code{nShapeParam}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nShapeParam}.}
    \item{\code{nShapeParamMinusOne}}{If \code{isSequential = TRUE}, mapped to the input dataset column
that lists the values for random effect \code{nShapeParamMinusOne}.}
  }}
}
\value{
\code{NlmePmlModel} object
}
\description{
Use to create a PK/Indirect response model.
}
\section{Column mapping}{

Note that quoted and unquoted column names are supported. Please see \code{\link{colMapping}}.
}

\examples{
model <- pkindirectmodel(
  parameterization = "Micro",
  data = pkpdData,
  ID = "ID",
  Time = "Time",
  A1 = "Dose",
  CObs = "CObs",
  EObs = "EObs"
)

# View PML Code
print(model)

}
