% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{pkcovbqlData}
\alias{pkcovbqlData}
\title{Pharmacokinetic pediatric dataset containing 80 subjects with single bolus dose.}
\format{
A data frame with 880 rows and 8 variables:
\describe{
  \item{ID}{Subject ID}
  \item{Time}{Nominal Time}
  \item{Dose}{Amount of dose}
  \item{CObs}{Observations of drug concentration in blood}
  \item{LLOQ}{Lower Limit of Quantification}
  \item{CObsBQL}{Variable that indicates whether the observed drug concentration is below the limit of quantification}
  \item{BW}{Body weight}
  \item{PMA}{Postmenstrual age}
}
}
\source{
The data is simulated using a one-compartment model with IV bolus, where the central volume is allometric weight scaled, and the clearance is scaled by a combination of allometric weight scaling and a sigmoidal maturation function driven by PMA. Germovsek E., et al, Pharmacokinetic–Pharmacodynamic Modeling in Pediatric Drug Development, and the Importance of Standardized Scaling of Clearance, Clin Pharmacokinet (2019) 58:39–52.
}
\usage{
pkcovbqlData
}
\description{
Pharmacokinetic pediatric dataset containing 80 subjects with single bolus dose. Dataset includes covariates and observations Below Quantification Limit (BQL).
}
\keyword{datasets}
