% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{catr_srs_values}
\alias{catr_srs_values}
\title{Reference SRS codes for \CRANpkg{CatastRo} APIs}
\format{
A \link[tibble:tbl_df-class]{tibble} with 16 rows
and columns:
\describe{
\item{SRS}{Spatial Reference System (CRS) value, identified by the
corresponding
\href{https://en.wikipedia.org/wiki/EPSG_Geodetic_Parameter_Dataset}{EPSG}
code.}
\item{Description}{Description of the SRS/EPSG code.}
\item{ovc_service}{Logical. Is this code valid on OVC services?}
\item{wfs_service}{Logical. Is this code valid on INSPIRE WFS services?}
}
}
\description{
A \link[tibble:tbl_df-class]{tibble} including the valid SRS (also known as CRS)
values that may be used on each API service. The values are provided
as \href{https://en.wikipedia.org/wiki/EPSG_Geodetic_Parameter_Dataset}{EPSG codes}.
}
\details{
Table: Content of \link{catr_srs_values}\tabular{llll}{
   \strong{SRS} \tab \strong{Description} \tab \strong{ovc_service} \tab \strong{wfs_service} \cr
   \code{3785} \tab \verb{Web Mercator} \tab \code{FALSE} \tab \code{TRUE} \cr
   \code{3857} \tab \verb{Web Mercator} \tab \code{FALSE} \tab \code{TRUE} \cr
   \code{4230} \tab \verb{Geográficas en ED 50} \tab \code{TRUE} \tab \code{FALSE} \cr
   \code{4258} \tab \verb{Geográficas en ETRS89} \tab \code{TRUE} \tab \code{TRUE} \cr
   \code{4326} \tab \verb{Geográficas en WGS 80} \tab \code{TRUE} \tab \code{TRUE} \cr
   \code{23029} \tab \verb{UTM huso 29N en ED50} \tab \code{TRUE} \tab \code{FALSE} \cr
   \code{23030} \tab \verb{UTM huso 30N en ED50} \tab \code{TRUE} \tab \code{FALSE} \cr
   \code{23031} \tab \verb{UTM huso 31N en ED50} \tab \code{TRUE} \tab \code{FALSE} \cr
   \code{25829} \tab \verb{UTM huso 29N en ETRS89} \tab \code{TRUE} \tab \code{TRUE} \cr
   \code{25830} \tab \verb{UTM huso 30N en ETRS89} \tab \code{TRUE} \tab \code{TRUE} \cr
   \code{25831} \tab \verb{UTM huso 31N en ETRS89} \tab \code{TRUE} \tab \code{TRUE} \cr
   \code{32627} \tab \verb{UTM huso 27N en WGS 84} \tab \code{TRUE} \tab \code{FALSE} \cr
   \code{32628} \tab \verb{UTM huso 28N en WGS 84} \tab \code{TRUE} \tab \code{FALSE} \cr
   \code{32629} \tab \verb{UTM huso 29N en WGS 84} \tab \code{TRUE} \tab \code{FALSE} \cr
   \code{32630} \tab \verb{UTM huso 30N en WGS 84} \tab \code{TRUE} \tab \code{FALSE} \cr
   \code{32631} \tab \verb{UTM huso 31N en WGS 84} \tab \code{TRUE} \tab \code{FALSE} \cr
}
}
\examples{
data("catr_srs_values")

# OVC valid codes
library(dplyr)

catr_srs_values |> filter(ovc_service == TRUE)

# WFS valid codes

catr_srs_values |> filter(wfs_service == TRUE)

# Use with sf::st_crs()

catr_srs_values |>
  filter(wfs_service == TRUE & ovc_service == TRUE) |>
  print() |>
  # First value
  slice_head(n = 1) |>
  pull(SRS) |>
  # As crs
  sf::st_crs(.)
}
\references{
\itemize{
\item \href{https://ovc.catastro.meh.es/ovcservweb/ovcswlocalizacionrc/ovccoordenadas.asmx}{OVCCoordenadas}.
\item \href{https://www.catastro.hacienda.gob.es/webinspire/index.html}{INSPIRE WFS Service}.
}
}
\seealso{
\code{\link[sf:st_crs]{sf::st_crs()}}.

Other databases: 
\code{\link{catr_atom_get_address_db_all}()},
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_atom_search_munic}()}

Other INSPIRE WFS services:
\code{\link{catr_wfs_get_address_bbox}()},
\code{\link{catr_wfs_get_buildings_bbox}()},
\code{\link{catr_wfs_get_parcels_bbox}()},
\code{\link{inspire_wfs_get}()}

OVCCoordenadas API:
\code{\link{catr_ovc_get_cpmrc}()},
\code{\link{catr_ovc_get_rccoor}()},
\code{\link{catr_ovc_get_rccoor_distancia}()}
}
\concept{OVCCoordenadas}
\concept{WFS}
\concept{databases}
