% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{cardioRiskFactors_df}
\alias{cardioRiskFactors_df}
\title{Cardiovascular Risk Factors}
\format{
A data frame with 998 observations and 14 variables:
\describe{
\item{age}{Age in years (integer)}
\item{bmi}{Body Mass Index in kg/m² (numeric)}
\item{waisthip}{Waist-to-hip ratio (numeric)}
\item{smok}{Smoking status (integer)}
\item{choles}{Total cholesterol in mg/dL (numeric)}
\item{trig}{Triglycerides in mg/dL (numeric)}
\item{hdl}{HDL cholesterol in mg/dL (numeric)}
\item{ldl}{LDL cholesterol in mg/dL (numeric)}
\item{sys}{Systolic blood pressure in mmHg (integer)}
\item{dia}{Diastolic blood pressure in mmHg (numeric)}
\item{Uric}{Uric acid level in mg/dL (integer)}
\item{sex}{Sex (integer)}
\item{alco}{Alcohol consumption (numeric)}
\item{apoa}{Apolipoprotein A in mg/dL (numeric)}
}
}
\source{
Data taken from the Rfit package version 0.27.0. Original study:
Heritier S, Cantoni E, Copt S, Victoria-Feser M (2009).
Robust Methods in Biostatistics.
New York: John Wiley and Sons.
}
\usage{
data(cardioRiskFactors_df)
}
\description{
This dataset, cardioRiskFactors_df, is a data frame containing information from
a study investigating the association between uric acid and cardiovascular risk
factors in developing countries. It includes data from 998 participants (474 men
and 524 women) aged 25-64 years.
}
\details{
The dataset name has been kept as 'cardioRiskFactors_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
CardioDataSets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a standard data frame. The original content has not been modified
in any way.
}
