% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meansres.r
\name{acc}
\alias{acc}
\title{Calculate Accuracy of Predicted Cell Types}
\usage{
acc(y.predict, y.truth, cts_notin_reference = NULL)
}
\arguments{
\item{y.predict}{A character vector representing the predicted cell type labels.}

\item{y.truth}{A character vector representing the true cell type labels.}

\item{cts_notin_reference}{A character vector specifying the cell types that should be excluded from the accuracy calculation. If \code{NULL}, all cell types are included. Default is \code{NULL}.}
}
\value{
A numeric value representing the accuracy, i.e., the proportion of correctly predicted labels among the considered cell types.
}
\description{
This function calculates the accuracy of predicted cell types by comparing the predicted labels to the true labels. It allows for the exclusion of certain cell types from the reference when calculating accuracy.
}
\details{
The function compares the predicted labels (`y.predict`) to the true labels (`y.truth`) and calculates the proportion of correct predictions. If `cts_notin_reference` is provided, cell types in this vector are excluded from the accuracy calculation.
}
\examples{
# Example usage:
y.predict <- c("A", "B", "A", "C", "A", "B")
y.truth <- c("A", "B", "C", "C", "A", "A")
acc_value <- acc(y.predict, y.truth)
print(acc_value)

}
