% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoneDensityFunctions.R
\name{landmark_check}
\alias{landmark_check}
\title{Check landmarks are close to the mesh}
\usage{
landmark_check(surface_mesh, landmarks, threshold = 1)
}
\arguments{
\item{surface_mesh}{mesh object}

\item{landmarks}{Dataframe. Columns are landmark name, x, y, and z coords}

\item{threshold}{Numeric. Distance landmark can be from surface without
warning being thrown}
}
\value{
String. Returns a message warning that landmarks are not on bone
surface
}
\description{
Check landmarks are close to the mesh
}
\examples{
\donttest{
  # Download bone model
  url <- "https://github.com/Telfer/BoneDensityMapping/releases/download/v1.0.2/test_CT_femur.stl"
  bone_filepath <- tempfile(fileext = ".stl")
  download.file(url, bone_filepath, mode = "wb")
  surface_mesh <- import_mesh(bone_filepath)
  landmark_path <- system.file("extdata", "test_femur.fcsv",
                             package = "BoneDensityMapping")
  landmarks <- import_lmks(landmark_path)
  landmark_check(surface_mesh, landmarks, threshold = 1.0)
}
}
\author{
Scott Telfer \email{scott.telfer@gmail.com}
}
