requireNamespace("readr")
requireNamespace("BeeBDC")
requireNamespace("dplyr")


## existing data
db_standardized <- dplyr::tribble(
              ~decimalLatitude, ~decimalLongitude, ~recordNumber,                                  ~recordedBy, ~individualCount, ~samplingProtocol, ~associatedTaxa,     ~sex,      ~catalogNumber, ~institutionCode, ~otherCatalogNumbers, ~recordId,                          ~occurrenceID, ~collectionID,            ~genus, ~specificEpithet, ~id,                                                       ~locality, ~database_id,     ~scientificName, ~infraspecificEpithet, ~country,                             ~coordinateUncertaintyInMeters,
                         2.233,              -90L,            NA,                              "James Ogilvie",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00323864",           "AMNH",                   NA,        NA, "85fb767f-1f99-482f-896c-69dce8b59097",            NA, "Pseudoanthidium",      "truncatum",  NA,                                                              NA,  "db_fake_1",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                         "T. D. A. Cockerell",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00323581",           "AMNH",                   NA,        NA, "63f56ed1-7391-4814-a298-c1b67ca986be",            NA,        "Halictus",        "simplex",  NA,                                                 "near Weing Sa",  "db_fake_2",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA, "T. D. A. Cockerell & Wilmatte P. Cockerell",               1L,                NA,              NA,   "MALE", "AMNH_IZC 00323583",           "AMNH",                   NA,        NA, "cde3718b-8621-4b3f-b203-4436961a4b73",            NA,        "Halictus",        "simplex",  NA, "Lake Waskesiu, at the beginning of the portage to Heart Lakes",  "db_fake_3",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                              "C. S. Brimley",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00324010",           "AMNH",                   NA,        NA, "82e1eab7-5d92-4358-aede-1fab15ba4eda",            NA,        "Halictus",        "simplex",  NA,                                                              NA,  "db_fake_4",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                         "T. D. A. Cockerell",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00323630",           "AMNH",                   NA,        NA, "c161e78e-c091-4483-adf4-6b54045283d7",            NA,        "Halictus",        "simplex",  NA,                     "Prince Albert National Park, Lake Ajawaan",  "db_fake_5",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                         "T. D. A. Cockerell",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00323584",           "AMNH",                   NA,        NA, "002a4861-5374-46ac-84d4-087762ba0c88",            NA,        "Halictus",        "simplex",  NA,                                                              NA,  "db_fake_6",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,       "T. D. A. Cockerell & Alice M. Mackie",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00323616",           "AMNH",                   NA,        NA, "5e848030-8e9d-4f64-873d-08fee631e7dd",            NA,        "Halictus",        "simplex",  NA,                                                              NA,  "db_fake_7",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                            "Alice M. Mackie",               1L,                NA,              NA,   "MALE", "AMNH_IZC 00323619",           "AMNH",                   NA,        NA, "250ba041-2727-43d0-a39e-8d3470f5a8bf",            NA,        "Halictus",        "simplex",  NA,                                                              NA,  "db_fake_8",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                         "T. D. A. Cockerell",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00323591",           "AMNH",                   NA,        NA, "4cad3ea9-11b3-4589-b1d1-0035a84ea861",            NA,        "Halictus",        "simplex",  NA,                                                              NA,  "db_fake_9",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                         "T. D. A. Cockerell",               1L,                NA,              NA,   "MALE", "AMNH_IZC 00323601",           "AMNH",                   NA,        NA, "dc3ebe14-f11f-45e9-b121-d34a8693284e",            NA,        "Halictus",        "simplex",  NA,                                                              NA, "db_fake_10",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                                "A. H. Manes",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00324011",           "AMNH",                   NA,        NA, "6f1d8a81-3a4a-4650-be8c-7102f073e90e",            NA,        "Halictus",        "simplex",  NA,                                                              NA, "db_fake_11",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                         "T. D. A. Cockerell",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00323627",           "AMNH",                   NA,        NA, "406433bc-9c08-4e94-9768-d8df0bdd92cb",            NA,        "Halictus",        "simplex",  NA,                                                              NA, "db_fake_12",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                            "Alice M. Mackie",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00323611",           "AMNH",                   NA,        NA, "bf53740e-e96c-4b5a-a0e9-6b4bea3b2448",            NA,        "Halictus",        "simplex",  NA,                                        "Kaieteur National Park", "db_fake_13",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                         "T. D. A. Cockerell",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00323613",           "AMNH",                   NA,        NA, "2e6d4df0-0a46-4837-b340-ed6f8166a831",            NA,        "Halictus",        "simplex",  NA,                                               "Kum Puang Creek", "db_fake_14",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                            "Alice M. Mackie",               1L,                NA,              NA,       NA, "AMNH_IZC 00323617",           "AMNH",                   NA,        NA, "c0642780-37dc-4625-8a30-eacd5dbd1b70",            NA,        "Halictus",        "simplex",  NA,                                                              NA, "db_fake_15",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                         "T. D. A. Cockerell",               1L,                NA,              NA, "FEMALE",       "Fake_data_1",           "AMNH",                   NA,        NA, "259d5501-c49c-4a0b-99fc-1595ffe403b1",            NA,        "Halictus",        "simplex",  NA,                                                              NA, "db_fake_16",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                                 "Easter Egg",               NA,                NA,              NA,       NA,       "Fake_data_2",      "Bee Place",                   NA,        NA,                        "not_a_number1",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent", "db_fake_17",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                                 "Easter Egg",               NA,                NA,              NA,       NA,       "Fake_data_3",      "Bee Place",                   NA,        NA,                        "not_a_number2",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent", "db_fake_18",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                                 "Easter Egg",               NA,                NA,              NA,       NA,       "Fake_data_4",      "Bee Place",                   NA,        NA,                        "not_a_number3",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent", "db_fake_19",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                                 "Easter Egg",               NA,                NA,              NA,       NA,       "Fake_data_5",      "Bee Place",                   NA,        NA,                        "not_a_number4",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent", "db_fake_20",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                                 "Easter Egg",               NA,                NA,              NA,       NA,       "Fake_data_6",      "Bee Place",                   NA,        NA,                        "not_a_number5",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent", "db_fake_21",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                                 "Easter Egg",               NA,                NA,              NA,       NA,       "Fake_data_7",      "Bee Place",                   NA,        NA,                        "not_a_number6",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent", "db_fake_22",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                                 "Easter Egg",               NA,                NA,              NA,       NA,       "Fake_data_8",      "Bee Place",                   NA,        NA,                        "not_a_number7",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent", "db_fake_23",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                                 "Easter Egg",               NA,                NA,              NA,       NA,       "Fake_data_9",      "Bee Place",                   NA,        NA,                        "not_a_number8",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent", "db_fake_24",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                                 "Easter Egg",               NA,                NA,              NA,       NA,      "Fake_data_10",      "Bee Place",                   NA,        NA,                        "not_a_number9",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent", "db_fake_25",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                                       "Nope",               NA,                NA,              NA,       NA,      "Fake_data_11",      "Bee Place",                   NA,        NA,                       "not_a_number10",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent", "db_fake_26",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                                       "Nope",               NA,                NA,              NA,       NA,      "Fake_data_12",      "Bee Place",                   NA,        NA,                       "not_a_number11",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent", "db_fake_27",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                                       "Nope",               NA,                NA,              NA,       NA,      "Fake_data_13",      "Bee Place",                   NA,        NA,                       "not_a_number12",            NA,    "Lasioglossum",  "semicaeruleum",  NA,                                                  "non-existent", "db_fake_28",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                                       "Nope",               NA,                NA,              NA,       NA,      "Fake_data_14",      "Bee Place",                   NA,        NA,                       "not_a_number13",            NA,    "Lasioglossum",  "semicaeruleum",  NA,                                                  "non-existent", "db_fake_29",      "Fake species",  "species",         "The incorporated states of nowhere",    100L,
                         2.233,              -90L,            NA,                                       "Nope",               NA,                NA,              NA,       NA,      "Fake_data_15",      "Bee Place",                   NA,        NA,                       "not_a_number14",            NA,    "Lasioglossum",  "semicaeruleum",  NA,                                                  "non-existent", "db_fake_30",      "Fake species",  "species",         "The incorporated states of nowhere",    100L
              )




## Paige corrections - this is FAKED DATA AND SHOULD NOT BE USED FOR ANYTHING EVER OTHER THAN THIS TEST
PaigeNAm <- dplyr::tribble(
              ~X.1,     ~X,            ~scientificName,         ~id, ~institutionCode, ~collectionCode, ~ownerInstitutionCode, ~collectionID,       ~basisOfRecord,                                                     ~occurrenceID, ~catalogNumber, ~otherCatalogNumbers,   ~kingdom,      ~phylum,    ~class,        ~order,      ~family, ~taxonID, ~scientificNameAuthorship,        ~genus, ~specificEpithet, ~taxonRank, ~infraspecificEpithet,      ~identifiedBy,        ~dateIdentified, ~identificationReferences, ~identificationRemarks, ~taxonRemarks, ~identificationQualifier, ~typeStatus,                              ~recordedBy, ~recordNumber,             ~eventDate, ~year,    ~month, ~day, ~startDayOfYear, ~endDayOfYear, ~verbatimEventDate, ~occurrenceRemarks, ~habitat, ~fieldNumber, ~informationWithheld, ~dataGeneralizations, ~dynamicProperties, ~associatedTaxa, ~associatedOccurrences, ~reproductiveCondition, ~establishmentMeans, ~lifeStage,     ~sex, ~individualCount, ~samplingProtocol, ~samplingEffort, ~preparations, ~country,     ~stateProvince,              ~county, ~municipality,                         ~locality, ~locationRemarks, ~decimalLatitude, ~decimalLongitude, ~geodeticDatum, ~coordinateUncertaintyInMeters, ~verbatimCoordinates, ~georeferencedBy, ~georeferenceProtocol, ~georeferenceSources, ~georeferenceVerificationStatus, ~georeferenceRemarks, ~minimumElevationInMeters, ~maximumElevationInMeters, ~minimumDepthInMeters, ~maximumDepthInMeters, ~verbatimDepth, ~verbatimElevation, ~disposition, ~language, ~recordEnteredBy,              ~modified, ~rights, ~rightsHolder, ~accessRights, ~recordId,                                                          ~references, ~finalLatitude, ~finalLongitude, ~Identifier_Level, ~PrecisionLevel, ~Source, ~geolocate_LocalityID, ~geolocate_ResultID, ~geolocate_Latitude, ~geolocate_Longitude, ~geolocate_UncertaintyRadiusMeters, ~geolocate_UncertaintyPolygon, ~geolocate_Score, ~geolocate_Precision, ~geolocate_ParsePattern, ~geolocate_locFieldUsed, ~geolocate_NumResults, ~wordCount,              ~finalName,    ~CountryName,
                1L, 20102L,     "Agapostemon borealis", 1317390166L,           "USNM",    "Entomology",                    NA,            NA, "PRESERVED_SPECIMEN", "http://n2t.net/ark:/65665/3084be498-793e-4b29-bb1d-0ad85253ef61",             NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "Halictidae",       NA,                        NA, "Agapostemon",       "borealis",  "SPECIES",                    NA,                 NA,                     NA,                        NA,                     NA,            NA,                       NA,          NA,                             "Livingston",            NA, "1896-04-04T00:00:00Z", 1896L,       "4",   4L,             95L,            NA,         "4/4/1996",                 NA,       NA,           NA,                   NA,                   NA,                 NA,              NA,                     NA,                     NA,                  NA,         NA, "FEMALE",               1L,                NA,              NA,      "Pinned",     "CA", "British Columbia",                   NA,            NA,                       "Vancouver",               NA,            2.233,          -90,             NA,                         10206L,                   NA,               NA,           "GEOLocate",                   NA,                              NA,                   NA,                        NA,                        NA,                    NA,                    NA,             NA,                 NA,           NA,        NA,               NA,                     NA,      NA,            NA,            NA,        NA,                                                                   NA,          49.25,        -123.133,        "Specimen",          "High",  "GBIF",                    NA,                  NA,                  NA,                   NA,                                 NA,                            NA,               NA,                   NA,                      NA,                      NA,                    NA,         2L,   "Agapostemon texanus",        "Canada",
                2L, 20103L, "Agapostemon californicus", 1101319745L,            "UCM",          "UCMC",                    NA,            NA, "PRESERVED_SPECIMEN",                            "7f6a4b80-642d-40f2-8dc7-eb45235f157c",             NA,                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "Halictidae",       NA,                        NA, "Agapostemon",   "californicus",  "SPECIES",                    NA, "T.D.A. Cockerell", "1939-01-01T00:00:00Z",                        NA,                     NA,            NA,                       NA,          NA,                       "T.D.A. Cockerell",            NA,                     NA,    NA, "Jun. 18",   NA,              NA,            NA,          "Jun. 18",                 NA,       NA,           NA,                   NA,                   NA,                 NA,              NA,                     NA,                     NA,                  NA,    "Adult",       NA,               1L,                NA,              NA,      "pinned",     "US",       "California", "Los Angeles County",            NA,             "San Clemente Island",               NA,             2.233,         -90,             NA,                         21236L,                   NA,               NA,                    NA,                   NA,                              NA,                   NA,                        NA,                        NA,                    NA,                    NA,             NA,                 NA,           NA,        NA,               NA, "2017-06-29T00:00:00Z",      NA,            NA,            NA,        NA,                                                                   NA,           32.9,       -118.5009,        "Specimen",          "High",  "GBIF",                    NA,                  NA,                  NA,                   NA,                                 NA,                            NA,               NA,                   NA,                      NA,                      NA,                    NA,         2L,   "Agapostemon texanus", "United States",
                5L, 23836L,    "Agapostemon leunculus",  658242510L,             "KU",          "SEMC",                    NA,            NA, "PRESERVED_SPECIMEN",                            "3aa3dd4b-1ed6-11e3-bfac-90b11c41863e",       "495676",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "Halictidae",       NA,                        NA, "Agapostemon",      "leunculus",  "SPECIES",                    NA,       "Roberts, R",                     NA,                        NA,                     NA,            NA,                       NA,          NA,             "Univ. of Kans. Mex. Exped.",            NA, "1961-06-11T00:00:00Z", 1961L,       "6",  11L,              NA,            NA,                 NA,                 NA,       NA,           NA,                   NA,                   NA,                 NA,              NA,                     NA,                     NA,                  NA,    "Adult",       NA,               NA,                NA,              NA,  "Pinned - 1",     "MX",         "Veracruz",                   NA,            NA,       "Alazan, 7 mi NW nr Tuxpan",               NA,          20.9915,         -97.54551,             NA,                             NA,                   NA,               NA,                    NA,                   NA,                              NA,                   NA,                        NA,                        NA,                    NA,                    NA,             NA,                 NA,           NA,        NA,               NA,                     NA,      NA,            NA,            NA,        NA,                                                                   NA,        20.9915,       -97.54551,        "Specimen",          "High",  "GBIF",                    NA,                  NA,                  NA,                   NA,                                 NA,                            NA,               NA,                   NA,                      NA,                      NA,                    NA,         2L, "Agapostemon leunculus",        "Mexico",
                6L, 23837L,    "Agapostemon leunculus", 1060982746L,           "EMEC",          "EMEC",                    NA,            NA, "PRESERVED_SPECIMEN",                                    "urn:catalog:EMEC:EMEC:511822",   "EMEC511822",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "Halictidae",       NA,                        NA, "Agapostemon",      "leunculus",  "SPECIES",                    NA,                 NA,                     NA,                        NA,                     NA,            NA,                       NA,          NA, "A. E. Michelbacher, M. M. Michelbacher",            NA, "1962-06-29T00:00:00Z", 1962L,       "6",  29L,              NA,            NA,                 NA,                 NA,       NA,           NA,                   NA,                   NA,                 NA,              NA,                     NA,                     NA,                  NA,    "Adult",       NA,               1L,                NA,              NA,         "pin",     "MX",          "Sinaloa",                   NA,            NA,                         "Rosario",               NA,         22.99325,         -105.8586,             NA,                          1405L,                   NA,               NA,                    NA,                   NA,                              NA,                   NA,                        NA,                        NA,                    NA,                    NA,             NA,                 NA,           NA,        NA,               NA, "2017-06-24T00:00:00Z",      NA,            NA,            NA,        NA, "http://essigdb.berkeley.edu/cgi/eme_query?bnhm_id=EMEC511822&one=T",       22.99325,       -105.8586,        "Specimen",          "High",  "GBIF",                    NA,                  NA,                  NA,                   NA,                                 NA,                            NA,               NA,                   NA,                      NA,                      NA,                    NA,         2L, "Agapostemon leunculus",        "Mexico",
                7L, 23838L,    "Agapostemon leunculus",  219014691L,         "IBUNAM",          "EBCC",                    NA,            NA,            "UNKNOWN",                                                   "not_a_number1",       "300182",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "Halictidae",       NA,                        NA, "Agapostemon",      "leunculus",  "SPECIES",                    NA,   "Douglas Yanega",                     NA,                        NA,                     NA,            NA,                       NA,          NA,            "Alicia Rodr√É¬≠guez Palafox",            NA, "1993-04-23T00:00:00Z", 1993L,       "4",  23L,              NA,            NA,                 NA,                 NA,       NA,           NA,                   NA,                   NA,                 NA,              NA,                     NA,                     NA,                  NA,         NA,       NA,               NA,                NA,              NA,            NA,     "MX",          "Chiapas",                   NA,            NA, "Ocosingo, Ej. Shanil, 52.9 km N",               NA,         17.21667,             -92.1,             NA,                             NA,                   NA,               NA,                    NA,                   NA,                              NA,                   NA,                        NA,                        NA,                    NA,                    NA,             NA,                 NA,           NA,        NA,               NA,                     NA,      NA,            NA,            NA,        NA,                                                                   NA,       17.21667,           -92.1,        "Specimen",          "High",  "GBIF",                    NA,                  NA,                  NA,                   NA,                                 NA,                            NA,               NA,                   NA,                      NA,                      NA,                    NA,         2L, "Agapostemon leunculus",        "Mexico",
                8L, 23839L,    "Agapostemon leunculus", 1060924636L,           "EMEC",          "EMEC",                    NA,            NA, "PRESERVED_SPECIMEN",                                    "urn:catalog:EMEC:EMEC:511782",   "EMEC511782",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "Halictidae",       NA,                        NA, "Agapostemon",      "leunculus",  "SPECIES",                    NA,                 NA,                     NA,                        NA,                     NA,            NA,                       NA,          NA, "A. E. Michelbacher, M. M. Michelbacher",            NA, "1962-07-27T00:00:00Z", 1962L,       "7",  27L,              NA,            NA,                 NA,                 NA,       NA,           NA,                   NA,                   NA,                 NA,              NA,                     NA,                     NA,                  NA,    "Adult",       NA,               1L,                NA,              NA,         "pin",     "MX",           "Oaxaca",                   NA,            NA,                          "Oaxaca",               NA,         17.06371,         -96.73192,             NA,                          8339L,                   NA,               NA,                    NA,                   NA,                              NA,                   NA,                        NA,                        NA,                    NA,                    NA,             NA,                 NA,           NA,        NA,               NA, "2017-05-04T00:00:00Z",      NA,            NA,            NA,        NA, "http://essigdb.berkeley.edu/cgi/eme_query?bnhm_id=EMEC511782&one=T",       17.06371,       -96.73192,        "Specimen",          "High",  "GBIF",                    NA,                  NA,                  NA,                   NA,                                 NA,                            NA,               NA,                   NA,                      NA,                      NA,                    NA,         2L, "Agapostemon leunculus",        "Mexico",
                9L, 23840L,    "Agapostemon leunculus", 1060924589L,           "EMEC",          "EMEC",                    NA,            NA, "PRESERVED_SPECIMEN",                                    "urn:catalog:EMEC:EMEC:511766",   "EMEC511766",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "Halictidae",       NA,                        NA, "Agapostemon",      "leunculus",  "SPECIES",                    NA,                 NA,                     NA,                        NA,                     NA,            NA,                       NA,          NA, "A. E. Michelbacher, M. M. Michelbacher",            NA, "1962-07-27T00:00:00Z", 1962L,       "7",  27L,              NA,            NA,                 NA,                 NA,       NA,           NA,                   NA,                   NA,                 NA,              NA,                     NA,                     NA,                  NA,    "Adult",       NA,               1L,                NA,              NA,         "pin",     "MX",           "Oaxaca",                   NA,            NA,                          "Oaxaca",               NA,         2.233,         -96.73192,             NA,                          8339L,                   NA,               NA,                    NA,                   NA,                              NA,                   NA,                        NA,                        NA,                    NA,                    NA,             NA,                 NA,           NA,        NA,               NA, "2017-05-04T00:00:00Z",      NA,            NA,            NA,        NA, "http://essigdb.berkeley.edu/cgi/eme_query?bnhm_id=EMEC511766&one=T",       17.06371,       -96.73192,        "Specimen",          "High",  "GBIF",                    NA,                  NA,                  NA,                   NA,                                 NA,                            NA,               NA,                   NA,                      NA,                      NA,                    NA,         2L, "Agapostemon leunculus",        "Mexico",
               10L, 23841L,    "Agapostemon leunculus",  219014682L,         "IBUNAM",          "EBCC",                    NA,            NA,            "UNKNOWN",                                                 "not_a_number11",       "300173",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "Halictidae",       NA,                        NA, "Agapostemon",      "leunculus",  "SPECIES",                    NA,   "Douglas Yanega",                     NA,                        NA,                     NA,            NA,                       NA,          NA,                             "J. L. Neff",            NA, "1993-04-12T00:00:00Z", 1993L,       "4",  12L,              NA,            NA,                 NA,                 NA,       NA,           NA,                   NA,                   NA,                 NA,              NA,                     NA,                     NA,                  NA,         NA,       NA,               NA,                NA,              NA,            NA,     "MX",          "Chiapas",                   NA,            NA,       "Tuxtla Gutierrez, 37 km E",               NA,            2.233,         90,             NA,                             NA,                   NA,               NA,                    NA,                   NA,                              NA,                   NA,                        NA,                        NA,                    NA,                    NA,             NA,                 NA,           NA,        NA,               NA,                     NA,      NA,            NA,            NA,        NA,                                                                   NA,          16.75,       -92.91667,        "Specimen",          "High",  "GBIF",                    NA,                  NA,                  NA,                   NA,                                 NA,                            NA,               NA,                   NA,                      NA,                      NA,                    NA,         2L, "Agapostemon leunculus",        "Mexico",
               11L, 23842L,    "Agapostemon leunculus",  219014681L,         "IBUNAM",          "EBCC",                    NA,            NA,            "UNKNOWN",                                                                NA,       "300172",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "Halictidae",       NA,                        NA, "Agapostemon",      "leunculus",  "SPECIES",                    NA,   "Douglas Yanega",                     NA,                        NA,                     NA,            NA,                       NA,          NA,                     "Wallace E. LaBerge",            NA, "1993-04-10T00:00:00Z", 1993L,       "4",  10L,              NA,            NA,                 NA,                 NA,       NA,           NA,                   NA,                   NA,                 NA,              NA,                     NA,                     NA,                  NA,         NA,       NA,               NA,                NA,              NA,            NA,     "MX",          "Chiapas",                   NA,            NA,           "Ocozocoautla, 17 km N",               NA,            16.89,            -93.46,             NA,                             NA,                   NA,               NA,                    NA,                   NA,                              NA,                   NA,                        NA,                        NA,                    NA,                    NA,             NA,                 NA,           NA,        NA,               NA,                     NA,      NA,            NA,            NA,        NA,                                                                   NA,          16.89,          -93.46,        "Specimen",          "High",  "GBIF",                    NA,                  NA,                  NA,                   NA,                                 NA,                            NA,               NA,                   NA,                      NA,                      NA,                    NA,         2L, "Agapostemon leunculus",        "Mexico",
               12L, 23843L,    "Agapostemon leunculus",  657759380L,             "KU",          "SEMC",                    NA,            NA, "PRESERVED_SPECIMEN",                            "1fc6766a-1ed6-11e3-bfac-90b11c41863e",       "496619",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "Halictidae",       NA,                        NA, "Agapostemon",      "leunculus",  "SPECIES",                    NA,       "Roberts, R",                     NA,                        NA,                     NA,            NA,                       NA,          NA,             "Univ. of Kans. Mex. Exped.",            NA, "1954-08-22T00:00:00Z", 1954L,       "8",  22L,              NA,            NA,                 NA,                 NA,       NA,           NA,                   NA,                   NA,                 NA,              NA,                     NA,                     NA,                  NA,    "Adult",       NA,               NA,                NA,              NA,  "Pinned - 1",     "MX",  "San Luis Potosi",                   NA,            NA,             "Ciudad Maiz, 5 mi E",               NA,         22.44681,         -99.56705,             NA,                             NA,                   NA,               NA,                    NA,                   NA,                              NA,                   NA,                        NA,                        NA,                    NA,                    NA,             NA,                 NA,           NA,        NA,               NA,                     NA,      NA,            NA,            NA,        NA,                                                                   NA,       22.44681,       -99.56705,        "Specimen",          "High",  "GBIF",                    NA,                  NA,                  NA,                   NA,                                 NA,                            NA,               NA,                   NA,                      NA,                      NA,                    NA,         2L, "Agapostemon leunculus",        "Mexico",
               13L, 23844L,    "Agapostemon leunculus", 1060924663L,           "EMEC",          "EMEC",                    NA,            NA, "PRESERVED_SPECIMEN",                                    "urn:catalog:EMEC:EMEC:511764",   "EMEC511764",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "Halictidae",       NA,                        NA, "Agapostemon",      "leunculus",  "SPECIES",                    NA,                 NA,                     NA,                        NA,                     NA,            NA,                       NA,          NA, "A. E. Michelbacher, M. M. Michelbacher",            NA, "1962-07-27T00:00:00Z", 1962L,       "7",  27L,              NA,            NA,                 NA,                 NA,       NA,           NA,                   NA,                   NA,                 NA,              NA,                     NA,                     NA,                  NA,    "Adult",       NA,               1L,                NA,              NA,         "pin",     "MX",           "Oaxaca",                   NA,            NA,                          "Oaxaca",               NA,         17.06371,         -96.73192,             NA,                          8339L,                   NA,               NA,                    NA,                   NA,                              NA,                   NA,                        NA,                        NA,                    NA,                    NA,             NA,                 NA,           NA,        NA,               NA, "2017-05-04T00:00:00Z",      NA,            NA,            NA,        NA, "http://essigdb.berkeley.edu/cgi/eme_query?bnhm_id=EMEC511764&one=T",       17.06371,       -96.73192,        "Specimen",          "High",  "GBIF",                    NA,                  NA,                  NA,                   NA,                                 NA,                            NA,               NA,                   NA,                      NA,                      NA,                    NA,         2L, "Agapostemon leunculus",        "Mexico",
               14L, 23845L,    "Agapostemon leunculus",  657733166L,             "KU",          "SEMC",                    NA,            NA, "PRESERVED_SPECIMEN",                            "1e5ca92c-1ed6-11e3-bfac-90b11c41863e",       "495671",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "Halictidae",       NA,                        NA, "Agapostemon",      "leunculus",  "SPECIES",                    NA,       "Roberts, R",                     NA,                        NA,                     NA,            NA,                       NA,          NA,             "Univ. of Kans. Mex. Exped.",            NA, "1961-06-11T00:00:00Z", 1961L,       "6",  11L,              NA,            NA,                 NA,                 NA,       NA,           NA,                   NA,                   NA,                 NA,              NA,                     NA,                     NA,                  NA,    "Adult",       NA,               NA,                NA,              NA,  "Pinned - 1",     "MX",         "Veracruz",                   NA,            NA,       "Alazan, 7 mi NW nr Tuxpan",               NA,          20.9915,         -97.54551,             NA,                             NA,                   NA,               NA,                    NA,                   NA,                              NA,                   NA,                        NA,                        NA,                    NA,                    NA,             NA,                 NA,           NA,        NA,               NA,                     NA,      NA,            NA,            NA,        NA,                                                                   NA,        20.9915,       -97.54551,        "Specimen",          "High",  "GBIF",                    NA,                  NA,                  NA,                   NA,                                 NA,                            NA,               NA,                   NA,                      NA,                      NA,                    NA,         2L, "Agapostemon leunculus",        "Mexico",
               15L, 23846L,    "Agapostemon leunculus", 1060924629L,           "EMEC",          "EMEC",                    NA,            NA, "PRESERVED_SPECIMEN",                                    "urn:catalog:EMEC:EMEC:511794",   "EMEC511794",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "Halictidae",       NA,                        NA, "Agapostemon",      "leunculus",  "SPECIES",                    NA,                 NA,                     NA,                        NA,                     NA,            NA,                       NA,          NA, "A. E. Michelbacher, M. M. Michelbacher",            NA, "1962-07-26T00:00:00Z", 1962L,       "7",  26L,              NA,            NA,                 NA,                 NA,       NA,           NA,                   NA,                   NA,                 NA,              NA,                     NA,                     NA,                  NA,    "Adult",       NA,               1L,                NA,              NA,         "pin",     "MX",           "Oaxaca",                   NA,            NA,                          "Oaxaca",               NA,         17.06371,         -96.73192,             NA,                          8339L,                   NA,               NA,                    NA,                   NA,                              NA,                   NA,                        NA,                        NA,                    NA,                    NA,             NA,                 NA,           NA,        NA,               NA, "2017-05-04T00:00:00Z",      NA,            NA,            NA,        NA, "http://essigdb.berkeley.edu/cgi/eme_query?bnhm_id=EMEC511794&one=T",       17.06371,       -96.73192,        "Specimen",          "High",  "GBIF",                    NA,                  NA,                  NA,                   NA,                                 NA,                            NA,               NA,                   NA,                      NA,                      NA,                    NA,         2L, "Agapostemon leunculus",        "Mexico",
               16L, 23847L,    "Agapostemon leunculus",  219014679L,         "IBUNAM",          "EBCC",                    NA,            NA,            "UNKNOWN",                                                                NA,       "300170",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "Halictidae",       NA,                        NA, "Agapostemon",      "leunculus",  "SPECIES",                    NA,   "Douglas Yanega",                     NA,                        NA,                     NA,            NA,                       NA,          NA,             "Felipe Noguera Mart√É¬≠nez",            NA, "1993-04-10T00:00:00Z", 1993L,       "4",  10L,              NA,            NA,                 NA,                 NA,       NA,           NA,                   NA,                   NA,                 NA,              NA,                     NA,                     NA,                  NA,         NA,       NA,               NA,                NA,              NA,            NA,     "MX",          "Chiapas",                   NA,            NA,           "Ocozocoautla, 17 km N",               NA,            16.89,            -93.46,             NA,                             NA,                   NA,               NA,                    NA,                   NA,                              NA,                   NA,                        NA,                        NA,                    NA,                    NA,             NA,                 NA,           NA,        NA,               NA,                     NA,      NA,            NA,            NA,        NA,                                                                   NA,          16.89,          -93.46,        "Specimen",          "High",  "GBIF",                    NA,                  NA,                  NA,                   NA,                                 NA,                            NA,               NA,                   NA,                      NA,                      NA,                    NA,         2L, "Agapostemon leunculus",        "Mexico",
               17L, 23848L,    "Agapostemon leunculus",  219014687L,         "IBUNAM",          "EBCC",                    NA,            NA,            "UNKNOWN",                                                                NA,       "300178",                   NA, "Animalia", "Arthropoda", "Insecta", "Hymenoptera", "Halictidae",       NA,                        NA, "Agapostemon",      "leunculus",  "SPECIES",                    NA,   "Douglas Yanega",                     NA,                        NA,                     NA,            NA,                       NA,          NA,                        "Claudia Mendoza",            NA, "1993-04-13T00:00:00Z", 1993L,       "4",  13L,              NA,            NA,                 NA,                 NA,       NA,           NA,                   NA,                   NA,                 NA,              NA,                     NA,                     NA,                  NA,         NA,       NA,               NA,                NA,              NA,            NA,     "MX",          "Chiapas",                   NA,            NA,                        "Teopisca",               NA,         16.53333,         -92.46667,             NA,                             NA,                   NA,               NA,                    NA,                   NA,                              NA,                   NA,                        NA,                        NA,                    NA,                    NA,             NA,                 NA,           NA,        NA,               NA,                     NA,      NA,            NA,            NA,        NA,                                                                   NA,       16.53333,       -92.46667,        "Specimen",          "High",  "GBIF",                    NA,                  NA,                  NA,                   NA,                                 NA,                            NA,               NA,                   NA,                      NA,                      NA,                    NA,         2L, "Agapostemon leunculus",        "Mexico"
              ) %>%
  # Change the column name from Source to dataSource to match the rest of the data.
  dplyr::rename(dataSource = Source) %>%
  # EXTRACT WAS HERE
  # add a NEW database_id column
  dplyr::mutate(
    database_id = paste0("Paige_data_", 1:nrow(.)),
    .before = scientificName)

  
  


columnList <-  list(c("decimalLatitude", "decimalLongitude", 
                   "recordNumber", "recordedBy", "individualCount", "samplingProtocol",
                   "associatedTaxa", "sex", "catalogNumber", "institutionCode", "otherCatalogNumbers",
                   "recordId", "occurrenceID", "collectionID"), # Iteration 1
c("catalogNumber", "institutionCode", "otherCatalogNumbers",
  "recordId", "occurrenceID", "collectionID"), # Iteration 2
c("decimalLatitude", "decimalLongitude", 
  "recordedBy", "genus", "specificEpithet"), # Iteration 3
c("id", "decimalLatitude", "decimalLongitude"), # Iteration 4
c("recordedBy", "genus", "specificEpithet", "locality"), # Iteration 5
c("recordedBy", "institutionCode", "genus", 
  "specificEpithet","locality"),# Iteration 6
c("occurrenceID","decimalLatitude", "decimalLongitude"), # Iteration 7
c("catalogNumber","decimalLatitude", "decimalLongitude"), # Iteration 8
c("catalogNumber", "locality") # Iteration 9
)

## generate new data using function
testOut <- BeeBDC::PaigeIntegrater(db_standardized = db_standardized, 
                                  PaigeNAm = PaigeNAm, 
                                  columnStrings = columnList)
                                   

## test the function
# the correct answer 
correct <- dplyr::tribble(
             ~decimalLatitude, ~decimalLongitude, ~recordNumber,                                  ~recordedBy, ~individualCount, ~samplingProtocol, ~associatedTaxa,     ~sex,      ~catalogNumber, ~institutionCode, ~otherCatalogNumbers, ~recordId,                          ~occurrenceID, ~collectionID,            ~genus, ~specificEpithet, ~id,                                                       ~locality,   ~database_id,         ~scientificName, ~infraspecificEpithet,                             ~country, ~coordinateUncertaintyInMeters,
                        2.233,               -90,            NA,                              "James Ogilvie",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00323864",           "AMNH",                   NA,        NA, "85fb767f-1f99-482f-896c-69dce8b59097",            NA, "Pseudoanthidium",      "truncatum",  NA,                                                              NA,    "db_fake_1",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                         "T. D. A. Cockerell",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00323581",           "AMNH",                   NA,        NA, "63f56ed1-7391-4814-a298-c1b67ca986be",            NA,        "Halictus",        "simplex",  NA,                                                 "near Weing Sa",    "db_fake_2",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA, "T. D. A. Cockerell & Wilmatte P. Cockerell",               1L,                NA,              NA,   "MALE", "AMNH_IZC 00323583",           "AMNH",                   NA,        NA, "cde3718b-8621-4b3f-b203-4436961a4b73",            NA,        "Halictus",        "simplex",  NA, "Lake Waskesiu, at the beginning of the portage to Heart Lakes",    "db_fake_3",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                              "C. S. Brimley",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00324010",           "AMNH",                   NA,        NA, "82e1eab7-5d92-4358-aede-1fab15ba4eda",            NA,        "Halictus",        "simplex",  NA,                                                              NA,    "db_fake_4",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                         "T. D. A. Cockerell",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00323630",           "AMNH",                   NA,        NA, "c161e78e-c091-4483-adf4-6b54045283d7",            NA,        "Halictus",        "simplex",  NA,                     "Prince Albert National Park, Lake Ajawaan",    "db_fake_5",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                         "T. D. A. Cockerell",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00323584",           "AMNH",                   NA,        NA, "002a4861-5374-46ac-84d4-087762ba0c88",            NA,        "Halictus",        "simplex",  NA,                                                              NA,    "db_fake_6",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,       "T. D. A. Cockerell & Alice M. Mackie",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00323616",           "AMNH",                   NA,        NA, "5e848030-8e9d-4f64-873d-08fee631e7dd",            NA,        "Halictus",        "simplex",  NA,                                                              NA,    "db_fake_7",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                            "Alice M. Mackie",               1L,                NA,              NA,   "MALE", "AMNH_IZC 00323619",           "AMNH",                   NA,        NA, "250ba041-2727-43d0-a39e-8d3470f5a8bf",            NA,        "Halictus",        "simplex",  NA,                                                              NA,    "db_fake_8",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                         "T. D. A. Cockerell",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00323591",           "AMNH",                   NA,        NA, "4cad3ea9-11b3-4589-b1d1-0035a84ea861",            NA,        "Halictus",        "simplex",  NA,                                                              NA,    "db_fake_9",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                         "T. D. A. Cockerell",               1L,                NA,              NA,   "MALE", "AMNH_IZC 00323601",           "AMNH",                   NA,        NA, "dc3ebe14-f11f-45e9-b121-d34a8693284e",            NA,        "Halictus",        "simplex",  NA,                                                              NA,   "db_fake_10",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                                "A. H. Manes",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00324011",           "AMNH",                   NA,        NA, "6f1d8a81-3a4a-4650-be8c-7102f073e90e",            NA,        "Halictus",        "simplex",  NA,                                                              NA,   "db_fake_11",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                         "T. D. A. Cockerell",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00323627",           "AMNH",                   NA,        NA, "406433bc-9c08-4e94-9768-d8df0bdd92cb",            NA,        "Halictus",        "simplex",  NA,                                                              NA,   "db_fake_12",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                            "Alice M. Mackie",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00323611",           "AMNH",                   NA,        NA, "bf53740e-e96c-4b5a-a0e9-6b4bea3b2448",            NA,        "Halictus",        "simplex",  NA,                                        "Kaieteur National Park",   "db_fake_13",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                         "T. D. A. Cockerell",               1L,                NA,              NA, "FEMALE", "AMNH_IZC 00323613",           "AMNH",                   NA,        NA, "2e6d4df0-0a46-4837-b340-ed6f8166a831",            NA,        "Halictus",        "simplex",  NA,                                               "Kum Puang Creek",   "db_fake_14",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                            "Alice M. Mackie",               1L,                NA,              NA,       NA, "AMNH_IZC 00323617",           "AMNH",                   NA,        NA, "c0642780-37dc-4625-8a30-eacd5dbd1b70",            NA,        "Halictus",        "simplex",  NA,                                                              NA,   "db_fake_15",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                         "T. D. A. Cockerell",               1L,                NA,              NA, "FEMALE",       "Fake_data_1",           "AMNH",                   NA,        NA, "259d5501-c49c-4a0b-99fc-1595ffe403b1",            NA,        "Halictus",        "simplex",  NA,                                                              NA,   "db_fake_16",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                     17.21667,             -92.1,            NA,                                 "Easter Egg",               NA,                NA,              NA,       NA,       "Fake_data_2",      "Bee Place",                   NA,        NA,                        "not_a_number1",            NA,     "Agapostemon",      "leunculus",  NA,                                                  "non-existent", "Paige_data_5", "Agapostemon leunculus",             "species",                                 "MX",                           100L,
                        2.233,               -90,            NA,                                 "Easter Egg",               NA,                NA,              NA,       NA,       "Fake_data_3",      "Bee Place",                   NA,        NA,                        "not_a_number2",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent",   "db_fake_18",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                                 "Easter Egg",               NA,                NA,              NA,       NA,       "Fake_data_4",      "Bee Place",                   NA,        NA,                        "not_a_number3",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent",   "db_fake_19",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                                 "Easter Egg",               NA,                NA,              NA,       NA,       "Fake_data_5",      "Bee Place",                   NA,        NA,                        "not_a_number4",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent",   "db_fake_20",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                                 "Easter Egg",               NA,                NA,              NA,       NA,       "Fake_data_6",      "Bee Place",                   NA,        NA,                        "not_a_number5",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent",   "db_fake_21",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                                 "Easter Egg",               NA,                NA,              NA,       NA,       "Fake_data_7",      "Bee Place",                   NA,        NA,                        "not_a_number6",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent",   "db_fake_22",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                                 "Easter Egg",               NA,                NA,              NA,       NA,       "Fake_data_8",      "Bee Place",                   NA,        NA,                        "not_a_number7",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent",   "db_fake_23",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                                 "Easter Egg",               NA,                NA,              NA,       NA,       "Fake_data_9",      "Bee Place",                   NA,        NA,                        "not_a_number8",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent",   "db_fake_24",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                                 "Easter Egg",               NA,                NA,              NA,       NA,      "Fake_data_10",      "Bee Place",                   NA,        NA,                        "not_a_number9",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent",   "db_fake_25",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                                       "Nope",               NA,                NA,              NA,       NA,      "Fake_data_11",      "Bee Place",                   NA,        NA,                       "not_a_number10",            NA,  "Augochloropsis",        "fulgida",  NA,                                                  "non-existent",   "db_fake_26",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        16.75,         -92.91667,            NA,                                       "Nope",               NA,                NA,              NA,       NA,      "Fake_data_12",      "Bee Place",                   NA,        NA,                       "not_a_number11",            NA,     "Agapostemon",      "leunculus",  NA,                                                  "non-existent", "Paige_data_8", "Agapostemon leunculus",             "species",                                 "MX",                           100L,
                        2.233,               -90,            NA,                                       "Nope",               NA,                NA,              NA,       NA,      "Fake_data_13",      "Bee Place",                   NA,        NA,                       "not_a_number12",            NA,    "Lasioglossum",  "semicaeruleum",  NA,                                                  "non-existent",   "db_fake_28",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                                       "Nope",               NA,                NA,              NA,       NA,      "Fake_data_14",      "Bee Place",                   NA,        NA,                       "not_a_number13",            NA,    "Lasioglossum",  "semicaeruleum",  NA,                                                  "non-existent",   "db_fake_29",          "Fake species",             "species", "The incorporated states of nowhere",                           100L,
                        2.233,               -90,            NA,                                       "Nope",               NA,                NA,              NA,       NA,      "Fake_data_15",      "Bee Place",                   NA,        NA,                       "not_a_number14",            NA,    "Lasioglossum",  "semicaeruleum",  NA,                                                  "non-existent",   "db_fake_30",          "Fake species",             "species", "The incorporated states of nowhere",                           100L
             )

  
testthat::test_that("PaigeIntegrater revised datatable with correct values", {
    testthat::expect_equal(testOut, correct)
})


