% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_initial_values.R
\name{set_initial_values}
\alias{set_initial_values}
\title{Set initial values of scale parameter and modal ranking}
\usage{
set_initial_values(rho_init = NULL, alpha_init = 1)
}
\arguments{
\item{rho_init}{Numeric vector specifying the initial value of the latent
consensus ranking \eqn{\rho}. Defaults to NULL, which means that the
initial value is set randomly. If \code{rho_init} is provided when
\code{n_clusters > 1}, each mixture component \eqn{\rho_{c}} gets the same
initial value.}

\item{alpha_init}{Numeric value specifying the initial value of the scale
parameter \eqn{\alpha}. Defaults to \code{1}. When \code{n_clusters > 1},
each mixture component \eqn{\alpha_{c}} gets the same initial value. When
chains are run in parallel, by providing an argument \code{cl = cl}, then
\code{alpha_init} can be a vector of of length \code{length(cl)}, each
element of which becomes an initial value for the given chain.}
}
\value{
An object of class \code{"BayesMallowsInitialValues"}, to be
provided to the \code{initial_values} argument of \code{\link[=compute_mallows]{compute_mallows()}} or
\code{\link[=compute_mallows_mixtures]{compute_mallows_mixtures()}}.
}
\description{
Set initial values used by the Metropolis-Hastings algorithm.
}
\seealso{
Other preprocessing: 
\code{\link{get_transitive_closure}()},
\code{\link{set_compute_options}()},
\code{\link{set_model_options}()},
\code{\link{set_priors}()},
\code{\link{set_progress_report}()},
\code{\link{set_smc_options}()},
\code{\link{setup_rank_data}()}
}
\concept{preprocessing}
