% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efftox_endpoint.R
\name{search_optimal_pars_efftox}
\alias{search_optimal_pars_efftox}
\title{Search optimal parameters for joint efficacy and toxicity endpoint}
\usage{
search_optimal_pars_efftox(
  H0,
  H1,
  n,
  nsim,
  t1e = NULL,
  method = "power",
  lambda1,
  lambda2,
  grid1,
  gamma1,
  gamma2,
  grid2,
  eta1 = NULL,
  eta2 = NULL,
  grid3 = NULL,
  seed = NULL
)
}
\arguments{
\item{H0}{A numeric vector representing the null response rates for different outcomes, specified in the following order:
- `H0[1]`: Response - toxicity,
- `H0[2]`: Response - no toxicity,
- `H0[3]`: No Response - toxicity,
- `H0[4]`: No Response - no toxicity}

\item{H1}{A numeric vector representing the null response rates for different outcomes, specified in the following order:
- `H1[1]`: Response - toxicity,
- `H1[2]`: Response - no toxicity,
- `H1[3]`: No Response - toxicity,
- `H1[4]`: No Response - no toxicity.}

\item{n}{A numeric vector representing the additional patients enrolled at each interim analysis.
The value at index \code{i} indicates the number of new patients added at interim analysis \code{i}. 
The total sample size at interim \code{i} is the cumulative sum of the values in \code{n} up to that index. 
For example, for four interim analyses with total sample sizes of 10, 15, 20, and 30, 
the vector would be represented as \code{n = c(10, 5, 5, 10)}, where:
\itemize{
  \item 10 is the number of patients enrolled at interim 1,
  \item 5 (15 - 10) is the additional number of patients enrolled at interim 2,
  \item 5 (20 - 15) is the additional number of patients enrolled at interim 3,
  \item 10 (30 - 20) is the additional number of patients enrolled at interim 4.
}}

\item{nsim}{number of simulation. A value at least 1000 for better result}

\item{t1e}{Desired Type - I error rate. If specified it will only return results with type I error rate less the specified value}

\item{method}{A character string specifying the method to use for calculating cutoff values for the efficacy stopping.
Options are "power" (default) or "OF" for "O'Brien-Fleming".}

\item{lambda1}{starting value for `lambda` values to search}

\item{lambda2}{ending value for `lambda` values to search}

\item{grid1}{number of `lambda` values to consider between lambda1 and lambda2}

\item{gamma1}{starting value for `gamma` values to search}

\item{gamma2}{ending value for `gamma` values to search}

\item{grid2}{number of `gamma` values to consider between gamma1 and gamma2}

\item{eta1}{starting value for `eta` values to search}

\item{eta2}{ending value for `eta` values to search}

\item{grid3}{number of eta values to consider between eta1 and eta2}

\item{seed}{for reproducibility}
}
\value{
A data frame with the following columns
\describe{
\item{fut_boundary_resp_i: }{Futility boundary for response at the ith analysis}
\item{fut_boundary_tox_i: }{Futility boundary for toxicity at the ith analysis}
\item{sup_boundary_resp_i: }{Superiority boundary for response at the ith analysis}
\item{sup_boundary_tox_i: }{Superiority boundary for toxicity at the ith analysis}
\item{earlystopfuti_mean_h0: }{Average number of early stopping due to futility under the null hypothesis}
 \item{earlystopsupe_mean_h0: }{Average number of early stopping for futility due to efficacy under the null hypothesis}
  \item{ss_mean_h0: }{Average sample size under the null hypothesis} 
  \item{rejectnull_mean_h0: }{Average number of hypothesis rejection at the final analysis under the null hypothesis} 
  \item{earlystopfuti_mean_h1: }{Average number of early stopping due to futility under the alternative hypothesis} 
  \item{earlystopsupe_mean_h1: }{Average number of early early stopping due to efficacy under the alternative hypothesis} 
  \item{ss_mean_h1: }{Average sample size under the alternative hypothesis} 
  \item{rejectnull_mean_h1: }{Average number of hypothesis rejection at the final analysis under the alternative hypothesis} 
  \item{lambda: }{lambda values for cut-off probability}
  \item{gamma: }{gamma values for cut-off probability}
  \item{eta: }{eta values for cut-off probability}}
}
\description{
`search_optimal_pars_efftox()` is a helper function and calls `get_boundary_oc_efftox()` to obtain the
optimal parameter combinations with type I error less than t1e and sorted according to power.
}
\examples{
test_joint <- search_optimal_pars_efftox(
 H0=c(0.15,0.30, 0.15, 0.40),
 H1= c(0.18,0.42, 0.02, 0.38),
 n = c(10, 5, 5),
 nsim = 1000,
 t1e = 0.1,
 method = "power",
 lambda1 = 0,
 lambda2 = 1,
 grid1 = 11,
 gamma1 = 0,
 gamma2 = 1,
 grid2 = 11,
 eta1 = 0,
 eta2 = 3,
 grid3 = 31,
 seed = 123
)

}
\keyword{internal}
