% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbi.R
\name{kusto-DBI}
\alias{kusto-DBI}
\alias{kusto_dbi}
\alias{AzureKusto_dbi}
\title{DBI interface to Kusto}
\description{
AzureKusto implements a subset of the DBI specification for interfacing with databases in R. The following methods are supported:
\itemize{
\item Connections: \link[DBI:dbConnect]{DBI::dbConnect}, \link[DBI:dbDisconnect]{DBI::dbDisconnect}, \link[DBI:dbCanConnect]{DBI::dbCanConnect}
\item Table management: \link[DBI:dbExistsTable]{DBI::dbExistsTable}, \link[DBI:dbCreateTable]{DBI::dbCreateTable}, \link[DBI:dbRemoveTable]{DBI::dbRemoveTable}, \link[DBI:dbReadTable]{DBI::dbReadTable}, \link[DBI:dbWriteTable]{DBI::dbWriteTable}
\item Querying: \link[DBI:dbGetQuery]{DBI::dbGetQuery}, \link[DBI:dbSendQuery]{DBI::dbSendQuery}, \link[DBI:dbFetch]{DBI::dbFetch}, \link[DBI:dbSendStatement]{DBI::dbSendStatement}, \link[DBI:dbExecute]{DBI::dbExecute}, \link[DBI:dbListFields]{DBI::dbListFields}, \link[DBI:dbColumnInfo]{DBI::dbColumnInfo}
}
}
\details{
Kusto is quite different to the SQL databases that DBI targets, which affects the behaviour of certain DBI methods and renders other moot.
\itemize{
\item Kusto is connectionless. \code{dbConnect} simply wraps a database endpoint object, created with \link{kusto_database_endpoint}. Similarly, \code{dbDisconnect} always returns TRUE. \code{dbCanConnect} attempts to check if querying the database will succeed, but this may not be accurate.
\item Temporary tables are not a Kusto concept, so \verb{dbCreateTable(*, temporary=TRUE)} will throw an error.
\item It only supports synchronous queries, with a default timeout of 4 minutes. \code{dbSendQuery} and \code{dbSendStatement} will wait for the query to execute, rather than returning immediately. The object returned contains the full result of the query, which \code{dbFetch} extracts.
\item The Kusto Query Language (KQL) is not SQL, and so higher-level SQL methods are not implemented.
}
}
