% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/zvariant-methods.R
\name{get_dat_param}
\alias{get_dat_param}
\alias{get_dat_param,Zvariant-method}
\title{Get a specified run setting parameter value}
\usage{
get_dat_param(x, parameter, warn_missing = TRUE)

\S4method{get_dat_param}{Zvariant}(x, parameter, warn_missing = TRUE)
}
\arguments{
\item{x}{Zvariant object.}

\item{parameter}{Character string name of the parameter.}

\item{warn_missing}{Logical indicating a warning should be raised of the
parameter is not used.}
}
\value{
Character string value of the parameter. If requested parameter is
  a valid Zonation parameter but not used currently, returns NA.
}
\description{
Essentially these are parameter values corresponding to Zonation dat-files.
This function is used to get values of given parameter. In the current
implementation, sections have no meaning.
}
\seealso{
\code{\link[zonator:Zvariant-class]{Zvariant-class}} and
\code{\link{set_dat_param}}.
}
\author{
Joona Lehtomaki \email{joona.lehtomaki@gmail.com}
}
