% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zfit.R
\name{zlm}
\alias{zlm}
\title{Run an lm model in a pipe}
\usage{
zlm(data, formula, ...)
}
\arguments{
\item{data}{A \code{data.frame} containing the model data.}

\item{formula}{The \code{formula} to be fitted.}

\item{...}{Other arguments to be passed to the \code{lm} function.}
}
\value{
A fitted model.
}
\description{
This function wraps around the \code{lm} function in order to make it
more friendly to pipe syntax (with the data first)
}
\examples{
# Pipe cars dataset into zlm for fitting
cars \%>\% zlm( speed ~ dist )

# Process iris with filter before piping to zlm (requires dplyr)
if(require("dplyr")) {
  iris \%>\%
    filter(Species=="setosa") \%>\%
    zlm(Sepal.Length ~ Sepal.Width + Petal.Width)
}

}
\seealso{
Other zfit: 
\code{\link{zglm}()},
\code{\link{zlogit}()},
\code{\link{zprint}()},
\code{\link{zprobit}()}
}
\concept{zfit}
