% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Beggs-Brill.R
\name{z.BeggsBrill}
\alias{z.BeggsBrill}
\title{Beggs and Brill correlation}
\usage{
z.BeggsBrill(pres.pr, temp.pr, tolerance = 1e-13, verbose = FALSE)
}
\arguments{
\item{pres.pr}{pseudo-reduced pressure}

\item{temp.pr}{pseudo-reduced temperature}

\item{tolerance}{rounding tolerance to avoid rounding readings that are in
the middle of the grid. "tolerance" adds flexibility in deciding point closeness.}

\item{verbose}{print internal}
}
\description{
Calculate the Z factor with the Brill-Beggs correlation
}
\examples{
## one single z calculation
z.BeggsBrill(pres.pr = 1.5, temp.pr = 2.0)
## calculate z for multiple values of Tpr and Ppr
ppr <- c(0.5, 1.5, 2.5, 3.5, 4.5, 5.5, 6.5)
tpr <- c(1.3, 1.5, 1.7, 2)
z.BeggsBrill(pres.pr = ppr, temp.pr = tpr)
}
