% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{fieldset}
\alias{fieldset}
\title{Group and label multiple inputs}
\usage{
fieldset(..., legend = NULL)
}
\arguments{
\item{...}{Any number of inputs to group or named arguments passed as HTML
attributes to the parent element.}

\item{legend}{A character string specifying the fieldset's legend.}
}
\description{
Use \code{fieldset} to associate and label inputs. This is good for screen readers
and other assistive technologies.
}
\examples{

### Grouping related inputs

fieldset(
  legend = "Pizza order",
  formGroup(
    "What toppings would you like?",
    div(
      checkbarInput(
        id = "toppings",
        choices = c(
          "Cheese",
          "Black olives",
          "Mushrooms"
        )
      )
    )
  ),
  formGroup(
    "Is this for delivery?",
    checkboxInput(
      id = "deliver",
      choice = "Deliver"
    )
  ),
  buttonInput("order", "Place order") \%>\%
    background("blue")
)

}
\seealso{
Other layout functions: \code{\link{column}},
  \code{\link{flex}}, \code{\link{navbar}},
  \code{\link{responsive}}, \code{\link{webpage}}
}
\concept{layout functions}
