% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{column}
\alias{column}
\alias{columns}
\alias{container}
\title{Grid layout}
\usage{
column(..., width = "equal")

columns(...)

container(..., centered = FALSE)
}
\arguments{
\item{...}{Any number of tags elements passed as child elements or named
arguments passed as HTML attributes to the parent element.}

\item{width}{A \link{responsive} argument. One of \code{1:12}, \code{"content"}, or
\code{"equal"}, defaults to \code{"equal"}.}

\item{centered}{One of \code{TRUE} or \code{FALSE} specifying how a container fills the
browser or viewport window. If \code{TRUE} the container is responsively
centered, otherwise, if \code{FALSE}, the container occupies the entire width of
the viewport, defaults to \code{FALSE}.}
}
\description{
These functions are the foundation of any application. Grid elements are
nested as follows: \code{container() > columns() > column() ~ column()}. A
\code{column()} may be created with an explicit width, 1 through 12. To fit a
column automatically to its content use \code{width = "content"}. To divide the
space in a row evenly amongst all columns use \code{width = "equal"}. For examples
and usage tips see the sections below.
}
\examples{

### Equal width columns

container(
  columns(
    column(
      "Aliquam erat volutpat."
    ),
    column(
      "Mauris mollis tincidunt felis."
    ),
    column(
      "Cum sociis natoque penatibus et magnis dis parturient montes,",
      "nascetur ridiculus mus."
    )
  )
)

###  Shiny's panel with sidebar layout

container(
  columns(
    column(
      width = 4,
      card(
        title = "Sidebar",
        formGroup(
          label = "Control 1",
          selectInput("control1", "...")
        ),
        formGroup(
          label = "Control 2",
          selectInput("control2", "...")
        ),
        formGroup(
          label = "Control 3",
          selectInput("control3", "...")
        )
      )
    ),
    column(
      d4("Main panel")
    )
  )
)

### Mobile friendly grids

# Use `column()`s [responsive] `width` argument to make mobile friendly
# applications.

container(
  columns(
    column(
      width = c(sm = 4),
      "Mauris ac felis vel velit tristique imperdiet."
    ),
    column(
      width = c(sm = 4),
      "Nam vestibulum accumsan nisl."
    ),
    column(
      width = c(sm = 4),
      "Proin neque massa, cursus ut, gravida ut, lobortis eget, lacus."
    )
  )
)

# or

container(
  columns(
    column(
      width = c(sm = 4),
      "Aenean in sem ac leo mollis blandit."
    ),
    column(
      width = c(sm = 8),
      "Nulla posuere. In id erat non orci commodo lobortis."
    )
  )
)

### Fit columns to their content

container(
  columns(
    column(),
    column(
      width = "content",
      "Cras placerat accumsan nulla. Aenean in sem ac leo mollis blandit."
    ),
    column()
  )
)

}
\seealso{
Other layout functions: \code{\link{fieldset}},
  \code{\link{flex}}, \code{\link{navbar}},
  \code{\link{responsive}}, \code{\link{webpage}}
}
\concept{layout functions}
