% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigen2hat.R
\name{eigen2hat}
\alias{eigen2hat}
\alias{eigen2map}
\alias{eigen2matrix}
\title{Calculate the hat matrix from an eigen decomposition}
\usage{
eigen2hat(eigen, val, lambda)

eigen2map(eigen, val, lambda)

eigen2matrix(eigen, val)
}
\arguments{
\item{eigen}{a matrix with the eigenvectors.}

\item{val}{an numeric vector with the eigenvalues.}

\item{lambda}{a single numeric value for the hyperparameter lambda}
}
\value{
a numeric matrix representing either the hat matrix
(\code{eigen2hat}), the map matrix (\code{eigen2map}) or
the original matrix (\code{eigen2matrix})
}
\description{
These functions calculate either the hat matrix, the mapping matrix or
the original (kernel) matrix for a two-step kernel ridge regression,
based on the eigendecomposition of the kernel matrix.
}
\details{
For the hat matrix, this boils down to:

\deqn{U\Sigma(\Sigma + \lambda I)^{-1} U^{T}}

For the map matrix, this is :

\deqn{U(\Sigma + \lambda I)^{-1} U^{T}}

with \eqn{U} the matrix with eigenvectors, \eqn{\Sigma} a diagonal matrix
with the eigenvalues on the diagonal, \eqn{I} the identity matrix and
\eqn{\lambda} the hyperparameter linked to this kernel.
The internal calculation is optimized to avoid having to invert
a matrix. This is done using the fact that \eqn{\Sigma} is a
diagonal matrix.
}
