% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmR_chart.R
\name{xmr_chart}
\alias{xmr_chart}
\title{Generate the XMR chart for XMR data}
\usage{
xmr_chart(df, time, measure, boundary_linetype = "dashed",
  central_linetype = "dotted", boundary_colour = "#d02b27",
  point_colour = "#7ECBB5", point_size = 2, line_width = 0.5,
  text_size = 9)
}
\arguments{
\item{df}{Output from xmR()}

\item{time}{Time column}

\item{measure}{Measure}

\item{boundary_linetype}{Type of line for upper and lower boundary lines. Defaults to "dashed".}

\item{central_linetype}{Type of line for central line. Defaults to "dotted".}

\item{boundary_colour}{Colour of line for upper and lower boundary lines. Defaults to "#d02b27".}

\item{point_colour}{Colour of points. Defaults to "#7ECBB5".}

\item{point_size}{Size of points. Defaults to 2.}

\item{line_width}{Width of lines. Defaults to 0.5.}

\item{text_size}{Size of chart text. Defaults to 9.}
}
\description{
Useful for diagnostics on xmr, and just visualizing the data.
}
\examples{
\donttest{
xmr_chart(df, "Year", "Measure")
}
}
