% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgx_annotate_status.R
\name{xgx_annotate_status}
\alias{xgx_annotate_status}
\title{Create a status (e.g. DRAFT) annotation layer}
\usage{
xgx_annotate_status(
  status = "DRAFT",
  x = Inf,
  y = Inf,
  color = "grey",
  hjust = 1.2,
  vjust = 1.2,
  fontsize = 7,
  fontface = "bold",
  alpha = 0.5,
  ...
)
}
\arguments{
\item{status}{the text to}

\item{x}{x location, default Inf (right most point)}

\item{y}{y location, default Inf (up most point)}

\item{color}{font color, default "grey"}

\item{hjust}{horizontal justification, default 1.2}

\item{vjust}{vertical justification, default 1.2}

\item{fontsize}{font size to use, default 7}

\item{fontface}{font style to use, default "bold"}

\item{alpha}{transparency, default is 0.5}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}}
}
\value{
ggplot layer
}
\description{
\code{xgx_annotate_status} adds a status (e.g. DRAFT) annotation layer 
to a plot. 
The text of the annotation can be customized, the default is "DRAFT". 
The color, location, size, fontface, transparency of the annotation can 
also be customized.
}
\examples{
data <- data.frame(x = 1:1000, y = rnorm(1000))
ggplot2::ggplot(data = data, ggplot2::aes(x = x, y = y)) + 
  ggplot2::geom_point() +
  xgx_annotate_status("DRAFT")

}
