% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgx_check_data.R
\name{xgx_check_data}
\alias{xgx_check_data}
\title{Check data for various issues}
\usage{
xgx_check_data(data, covariates = NULL)
}
\arguments{
\item{data, }{the dataset to check.  Must contain the above columns}

\item{covariates, }{the column names of covariates, to explore}
}
\value{
data.frame
}
\description{
\code{xgx_check_data} performs a series of checks on a PK or PKPD dataset
It was inspired by the dataset preparation table from 
\href{https://iqrtools.intiquan.com/doc/book/analysis-dataset-preparation.html}{IntiQuan}.
}
\details{
The dataset must have the following columns
\itemize{
  \item ID      = unique subject identifier.  USUBJID is another option 
  if ID is not there
  \item EVID    = event ID: 1 for dose, 0 otherwise
  \item AMT     = value of the dose
  \item TIME    = time of the measurement
  \item DV      = dependent value (linear scale).  will check if LIDV or 
  LNDV are also there if DV is not
  \item YTYPE   = data measurement for LIDV.  will check if CMT is there, 
  if YTYPE is not
}

The dataset may also have additional columns
\itemize{
  \item CENS = flag for censoring of the data because it's below the 
  limit of quantification (BLOQ)
  \item MDV  = missing dependent variable - will be counted and then 
  filtered out from the data check
}
}
\examples{
covariates <- c("WEIGHTB", "SEX")
check <- xgx_check_data(mad_missing_duplicates, covariates)

}
