% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histW.R
\name{histW}
\alias{histW}
\title{Histogram (version by WR)}
\usage{
histW(
  dat,
  fileName = "histW",
  output = "screen",
  nBars = 8,
  breaks = NULL,
  tit = NULL,
  subTi = NULL,
  xLab = NULL,
  yLab = NULL,
  las = NULL,
  xcex = 0.7,
  imgxSize = 900,
  useCol = NULL,
  useBord = NULL,
  isLog = TRUE,
  cexSubTi = NULL,
  cropHist = TRUE,
  parDefault = TRUE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{(matrix, list or data.frame) data to plot}

\item{fileName}{(character) name of file for saving graphics}

\item{output}{(character, length=1) options for output on 'screen' or saving image in various formats (set to 'jpg','png' or 'tif')}

\item{nBars}{(integer) number of bars in histogram (default for 'low resolution' plot to give rough overview)}

\item{breaks}{(integer) for (partial) compatibility with hist() : use only for number of breaks (or 'FD'), gets priority over 'nBars'}

\item{tit}{(character) custom title}

\item{subTi}{(character) may be \code{FALSE} for NOT displaying, or any text, otherwise range}

\item{xLab}{(character) custom x-axes label}

\item{yLab}{(character) custom y-axes label}

\item{las}{(integer) optional fixed text orientation of x-axis numbers : use 1 for horizontal and 2 for perpendicular, see also \code{\link[graphics]{par}}}

\item{xcex}{(numeric) cex-type expansion factor for x-axis numbers, see also \code{\link[graphics]{par}}}

\item{imgxSize}{(integer) width of image when saving to file, see also \code{\link[graphics]{par}}}

\item{useCol}{(character or integer) custom colors, see also \code{\link[graphics]{par}}}

\item{useBord}{(character) custom histogram elements border color, see also \code{\link[graphics]{par}}}

\item{isLog}{(logical) for lin scale signal intensity values where repesentation needs log, assume log2 if \code{TRUE}}

\item{cexSubTi}{(numerical) subtitle size (expansion factor cex), see also \code{\link[graphics]{par}}}

\item{cropHist}{(logical) -not implemented yet- designed for cutting off bars with very low ('insignificant') values}

\item{parDefault}{(logical) to automatic adjusting par(marg=,cex.axis=0.8), see also \code{\link[graphics]{par}}}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additonal messagesfor debugging}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\description{
This function proposes a few special tweaks to the general \code{\link[graphics]{hist}} function :
In a number of settings data are treated and plotted as log-data. This function allows feeding directly log2-data and displaying the x-axis   
(re-translated) in linear scale (see argument \code{isLog}). 
The default settings allow making (very) small histograms ('low resolution'), which may be used as a rough overview of bandwidth and distribution of values in \code{dat}. 
Similar to \code{\link[graphics]{hist}}, by changing the parameters \code{nBars} and/or \code{breaks} very 'high resolution' histograms can be produced.
By default it displays n per set of data (on the top of the figure). 
Note that the argument for (costom) title \code{main} is now called \code{tit}.
}
\examples{
set.seed(2016); dat1 <- round(c(rnorm(200,6,0.5),rlnorm(300,2,0.5),rnorm(100,17)),2)
dat1 <- dat1[which(dat1 <50 & dat1 > 0.2)]
histW(dat1,br="FD",isLog=FALSE)
histW(log2(dat1),br="FD",isLog=TRUE)

## quick overview of distributions  
layout(partitionPlot(4))
for(i in 1:4) histW(iris[,i],isLog=FALSE,tit=colnames(iris)[i])
}
\seealso{
\code{\link[graphics]{hist}}
}
