% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mouseOverHtmlFile.R
\name{mouseOverHtmlFile}
\alias{mouseOverHtmlFile}
\title{Create mouse-over interactive html-pages (with links)}
\usage{
mouseOverHtmlFile(
  myCoor,
  pngFileNa,
  HtmFileNa = NULL,
  mouseOverTxt = NULL,
  displSi = c(800, 600),
  colNa = NULL,
  tit = "",
  myHtmTit = "",
  myComment = NULL,
  textAtStart = NULL,
  textAtEnd = NULL,
  pxDiam = 5,
  addLinks = NULL,
  linkExt = NULL,
  htmlExt = "htm",
  callFrom = NULL,
  silent = FALSE
)
}
\arguments{
\item{myCoor}{(matrix or data.frame) with initial x&y coordinates of points for plot; with IDs (1st column !!) & coordinates (2nd & 3rd col), data for mouse-over & link (4th & 5th); 
NOTE : if 'colNa' NOT given, colnames of 'myCoor' will be inspected & filtered (columns of non-conform names may get lost) !!!  
Associated with (already existing) figure file 'pngFileNa' and make html page where points may be indicated by mouse-over}

\item{pngFileNa}{(character, length=1) filename for complementary png figure (must already exist)}

\item{HtmFileNa}{(character, length=1) filename for html file produced}

\item{mouseOverTxt}{(character, length=1) text for interactive mouse-over in html, if \code{NULL}, will use col specified by 1st 'colNa' or (if NULL) rownames of 'myCoor'}

\item{displSi}{(integer, length=2)  size of image ('pngFileNa') at display in html (width,height), see also \code{\link[graphics]{par}}}

\item{colNa}{(character) if not \code{NULL} min length of 3 to custom specify the column-names to be used : 1st for mouse-over and 2nd+3rd for coordinates associated (and optional 4th for links)}

\item{tit}{(character) title to be displayed on top of figure}

\item{myHtmTit}{(character) title of Html page; 'htmlExt' .. checking and correcting filename-extension (only main Html page)}

\item{myComment}{(character) modify comment embedded in html-document}

\item{textAtStart}{(character) text in html before figure}

\item{textAtEnd}{(character) text in html after figure}

\item{pxDiam}{(integer, length=1) diameter for mouse-over tip to appear (single val or vector), simpler version/solution than with 'Tooltip' package}

\item{addLinks}{(character) for clickable links, either 1) vector of links or 2) single character-chain to be used for pasting to rownames (eg http://www.uniprot.org/uniprot/)
or 3) \code{TRUE} to check presence of 4th name specified in 'colNa' to be useed as columname from 'myCoor'   dominates over eventual presence of 4th name in 'colNa'}

\item{linkExt}{(character) if specified : links will get specified ending, define as \code{NULL} or "" for taking 'addLinks' asIs}

\item{htmlExt}{(character, length=1) extension used when making html files}

\item{callFrom}{(character) allow easier tracking of message(s) produced}

\item{silent}{(logical) suppress messages}
}
\value{
plot
}
\description{
This function allows generating html pages with interactive mouse-over to display information for the points of the plot and www-links when clicking based on embedded png file.  
Basically, an html page will be generated which contains a call to display to an image file specified in \code{pngFileNa} and in the body below pixel-coordinated will be 
given for disply of information at mouse-over and embedded links.
}
\details{
Basically theer are two options for defining the path to the image embedded : 
1) Absolute path : I turn you can moove the html to different locations, as long as it still can see the png-file the image can be displayed. However, this may 
 not be any more the case when the html file is sent to another person. If the png-file is accessible as url, it should be easily visible. 
2) Relative path : The simplest case would be to give only the file-name with no path at all, thus the png-file is supposed to be in the same directory as the html-file. 
This option is very 'transportable'. 
Basically the same applies to the clickable links which may be provided. In high-throughput biology one typically points here to data-bases accessible
over the internet where urls to specific pages. With UniProt such links can easily be constructed when using protein identifiers as rownames.
}
\examples{
## Note, this example writes files to R's tempdir,
## Otherwise, if you simply work in the current directory without spcifying paths you'll 
##  get an html with relatove paths, which simply needs the png file in the same path 
df1 <- data.frame(id=letters[1:10],x=1:10,y=rep(5,10),mou=paste("point",letters[1:10]),
  link=file.path(tempdir(),paste(LETTERS[1:10],".html",sep="")),stringsAsFactors=FALSE)  
## here we'll use R's tempdir, later you may want to choose other locations
pngFile <- file.path(tempdir(),"test01.png")
png(pngFile,width=800, height=600,res=72)
## here we'll just plot a set of horiontal points ...
plot(df1[,2:3],las=1,main="test01")
dev.off()
## Note : Special characters should be converted for display in html pages during mouse-over
library(wrMisc)
df1$mou <- htmlSpecCharConv(df1$mou)
## Let's add the x- and y-coordiates of the points in pixels to the data.frame
df1 <- cbind(df1,convertPlotCoordPix(x=df1[,2],y=df1[,3],plotD=c(800,600),plotRes=72))
head(df1)
## Now make the html-page allowing to display mouse-over to the png made before
htmFile <- file.path(tempdir(),"test01.html")
mouseOverHtmlFile(df1,pngFile,HtmFileNa=htmFile,pxDiam=15,
  textAtStart="Points in the figure are interactive to mouse-over ...",
  textAtEnd="and/or may contain links")
## We still need to make some toy links
for(i in 1:nrow(df1)) cat(paste("point no ",i," : ",df1[i,1]," x=",df1[i,2]," y=",
  df1[i,3],sep=""), file=df1$link[i]) 
## Now we are ready to open the html file using any browser
\dontrun{ 
browseURL(htmFile)
}
}
\seealso{
\code{\link{convertPlotCoordPix}}; use \code{\link[wrMisc]{htmlSpecCharConv}} to convert special characters for proper html display
}
