% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{create_pca}
\alias{create_pca}
\title{Method for pca creation.}
\usage{
create_pca(data, color.group = NULL, color.title = NULL, palette = NULL,
  shape.group = NULL, shape.title = NULL, shapes = c(15:25),
  dimension.a = 1, dimension.b = 2, dimensions = 6, on.columns = TRUE,
  labels = FALSE, custom.labels = NULL, pointsize = 2, labelsize = 3,
  width = 28, height = 28, ppi = 72, scale = 1)
}
\arguments{
\item{data}{data.table from which the plot is created (First column will be handled as rownames if not numeric).}

\item{color.group}{Vector of groups according to samples (= column names).}

\item{color.title}{Title of the color legend.}

\item{palette}{Vector of colors used for color palette.}

\item{shape.group}{Vector of groups according to samples (= column names).}

\item{shape.title}{Title of the shape legend.}

\item{shapes}{Vector of shapes see \code{\link[graphics]{points}}. Will recycle/ cut off shapes if needed. Default = c(15:25)}

\item{dimension.a}{Number of dimension displayed on X-Axis.}

\item{dimension.b}{Number of dimension displayed on Y-Axis.}

\item{dimensions}{Number of dimensions to create.}

\item{on.columns}{Boolean perform pca on columns or rows.}

\item{labels}{Boolean show labels.}

\item{custom.labels}{Vector of custom labels. Will replace columnnames.}

\item{pointsize}{Size of the data points.}

\item{labelsize}{Size of texts inside plot (default = 3).}

\item{width}{Set the width of the plot in cm (default = 28).}

\item{height}{Set the height of the plot in cm (default = 28).}

\item{ppi}{Pixel per inch (default = 72).}

\item{scale}{Modify plot size while preserving aspect ratio (Default = 1).}
}
\value{
A named list(plot = ggplot object, data = pca.data, width = width of plot (cm), height = height of plot (cm), ppi = pixel per inch, exceed_size = Boolean whether width/ height exceeded max).
}
\description{
Method for pca creation.
}
\details{
If width and height are the same axis ratio will be set to one (quadratic plot).

Width/ height limit = 500. If exceeded default to 500 and issue exceed_size = TRUE.
}
