% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{aqi}
\alias{aqi}
\title{Air quality data records for California from 2011 through 2015}
\format{
A dataframe with 102752 rows and 10 variables:
\describe{
  \item{state_code}{Two-digit code from the FIPS publication 6-4 for states}
  \item{county_code}{Three-digit code from the FIPS publication 6-4 for counties}
  \item{county_name}{County name from the FIPS publication 6-4 for counties}
  \item{date}{Date on which the air quality measures were recorded}
  \item{aqi}{AQI level}
  \item{co}{Carbon monoxide, in Parts per million}
  \item{ozone}{Ozone, in Parts per million}
  \item{no2}{Nitrogen dioxide (NO2), in Parts per billion}
  \item{pm25}{PM2.5, in Micrograms/cubic meter (LC)}
  \item{pm10}{PM10, in Micrograms/cubic meter (25 C)}
}
}
\source{
\url{https://aqs.epa.gov/aqsweb/documents/data_api.html}
}
\usage{
aqi
}
\description{
A dataframe containing Calfornia air quality records at the county level.
It is created from the EPA's Air Quality System (AQS) API by fetching the
AQI along with other atmospheric measurements like CO, Ozone, NO2, PM2.5,
and PM10 and reforrmatting the tibble as a tidy data consisting of a row
per county per day.
}
\details{
AQS contains ambient air sample data collected by state, local, tribal, and
federal air pollution control agencies from thousands of monitors around the nation.
}
\keyword{datasets}
