% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wbt.R
\name{wbt_run_tool}
\alias{wbt_run_tool}
\title{Run a tool in 'WhiteboxTools' by name}
\usage{
wbt_run_tool(tool_name, args, verbose_mode = FALSE, command_only = FALSE)
}
\arguments{
\item{tool_name}{The name of the tool to run.}

\item{args}{Tool arguments.}

\item{verbose_mode}{Verbose mode. Without this flag, tool outputs will not be printed.}

\item{command_only}{Return command that would be run with \code{system()}? Default: \code{FALSE}}
}
\value{
Returns the (character) output of the tool.
}
\description{
Runs a tool and specifies tool arguments. If the prefix "whitebox::" or "wbt_" is in \code{tool_name} it is removed to match the definitions in \code{wbt_list_tools()}
}
\examples{
\dontrun{
tool_name <- "breach_depressions"
dem <- system.file("extdata", "DEM.tif", package="whitebox")
output <- "./output.tif"
arg1 <- paste0("--dem=", dem)
arg2 <- paste0("--output=", output)
args <- paste(arg1, arg2)
wbt_run_tool(tool_name, args)
}
}
\seealso{
\link{wbt_list_tools}
}
\keyword{General}
