% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_estimation.R
\name{ml_estimation.default}
\alias{ml_estimation.default}
\title{ML Estimation for Parametric Lifetime Distributions}
\usage{
\method{ml_estimation}{default}(
  x,
  status,
  distribution = c("weibull", "lognormal", "loglogistic", "normal", "logistic", "sev",
    "weibull3", "lognormal3", "loglogistic3"),
  wts = rep(1, length(x)),
  conf_level = 0.95,
  ...
)
}
\arguments{
\item{x}{A numeric vector which consists of lifetime data. Lifetime
data could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{status}{A vector of binary data (0 or 1) indicating whether unit \emph{i}
is a right censored observation (= 0) or a failure (= 1).}

\item{distribution}{Supposed distribution of the random variable.}

\item{wts}{Optional vector of case weights. The length of \code{wts} must be the
same as the number of observations in \code{x}.}

\item{conf_level}{Confidence level of the interval.}

\item{...}{Further arguments passed to or from other methods. Currently not used.}
}
\value{
Returns a list with classes \code{wt_model}, \code{wt_ml_estimation} and
\code{wt_model_estimation} containing the following elements:
\itemize{
  \item \code{coefficients} : A named vector of estimated coefficients
    (parameters of the assumed distribution). \strong{Note}: The parameters
    are given in location-scale-parameterization.
  \item \code{confint} : Confidence intervals for parameters.
  \item \code{varcov} : Estimated variance-covariance matrix for the
    parameters.
  \item \code{shape_scale_coefficients} : Only included if
    \code{distribution} is \code{"weibull"} or \code{"weibull3"}
    (parameterization used in \code{\link[stats:Weibull]{stats::Weibull}}).
  \item \code{shape_scale_confint} : Only included if \code{distribution} is
    \code{"weibull"} or \code{"weibull3"}. Confidence intervals
    for scale \eqn{\eta} and shape \eqn{\beta} (and threshold \eqn{\gamma})
    if \code{distribution} is \code{"weibull3"}.
  \item \code{logL} : The log-likelihood value.
  \item \code{aic} : Akaike Information Criterion.
  \item \code{bic} : Bayesian Information Criterion.
  \item \code{data} : A tibble with class \code{wt_reliability_data} returned from \code{\link{reliability_data}}.
  \item \code{distribution} : Specified distribution.
}
}
\description{
This function estimates the parameters of a two- or three-parametric lifetime
distribution for complete and (multiple) right censored data. The parameters
are determined in the frequently used (log-)location-scale parameterization.

For the Weibull, estimates are additionally transformed such that they are in
line with the parameterization provided by the \emph{stats} package
(see \link[stats]{Weibull}).
}
\details{
\code{ml_estimation} calls \code{\link[SPREDA:lifedata.MLE]{Lifedata.MLE}},
which is implemented in \emph{SPREDA}, to obtain the estimates. Normal
approximation confidence intervals for the parameters are computed as well.
}
\examples{
# Vectors:
obs <- seq(10000, 100000, 10000)
status_1 <- c(0, 1, 1, 0, 0, 0, 1, 0, 1, 0)

cycles <- alloy$cycles
status_2 <- alloy$status

# Example 1 - Fitting a two-parametric weibull distribution:
ml <- ml_estimation(
  x = obs,
  status = status_1,
  distribution = "weibull",
  conf_level = 0.90
)

# Example 2 - Fitting a three-parametric lognormal distribution:
ml_2 <- ml_estimation(
  x = cycles,
  status = status_2,
  distribution = "lognormal3"
)

}
\references{
Meeker, William Q; Escobar, Luis A., Statistical methods for
  reliability data, New York: Wiley series in probability and statistics, 1998
}
\seealso{
\code{\link{ml_estimation}}
}
