% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_intervals.R
\name{confint_fisher}
\alias{confint_fisher}
\title{Fisher Confidence Bounds for Quantiles and/or Probabilities}
\usage{
confint_fisher(x, event, loc_sc_params, loc_sc_varcov,
  distribution = c("weibull", "lognormal", "loglogistic", "normal",
  "logistic", "sev", "weibull3", "lognormal3", "loglogistic3"),
  bounds = c("two_sided", "lower", "upper"), conf_level = 0.95,
  direction = c("y", "x"))
}
\arguments{
\item{x}{a numeric vector which consists of lifetime data. \code{x} is used to
specify the range of confidence region(s).}

\item{event}{a vector of binary data (0 or 1) indicating whether unit \emph{i}
is a right censored observation (= 0) or a failure (= 1).}

\item{loc_sc_params}{a (named) numeric vector of estimated
(by Maximum Likelihood) location and scale parameters for a specified
distribution. The order of elements is important. First entry needs to be
the location parameter \eqn{\mu} and the second element needs to be the
scale parameter \eqn{\sigma}. If a three-parametric model is used the third element
is the threshold parameter \eqn{\gamma}.}

\item{loc_sc_varcov}{a (named) numeric matrix of estimated
(by Maximum Likelihood) location and scale variances and covariances for a
specified distribution. The order of elements is important. First entry
of the diagonal needs to be the variance of the location parameter
Var(\eqn{\mu}) and the second element of the diagonal needs to be the
variance of the scale parameter Var(\eqn{\sigma}). If a three-parametric model
is used the third element of the diagonal needs to be the variance of the
threshold parameter Var(\eqn{\gamma}).}

\item{distribution}{supposed distribution of the random variable. The
value can be \code{"weibull"}, \code{"lognormal"}, \code{"loglogistic"},
\code{"normal"}, \code{"logistic"}, \code{"sev"} \emph{(smallest extreme value)},
\code{"weibull3"}, \code{"lognormal3"} or \code{"loglogistic3"}.
Other distributions have not been implemented yet.}

\item{bounds}{a character string specifying the interval(s) which has/have to
be computed. Must be one of "two_sided" (default), "lower" or "upper".}

\item{conf_level}{confidence level of the interval. The default value is
\code{conf_level = 0.95}.}

\item{direction}{a character string specifying the direction of the computed
interval(s). Must be either "y" (failure probabilities) or "x" (quantiles).}
}
\value{
A data frame containing the lifetime characteristic, the
  probabilities, estimated standard errors by the delta method and computed
  values for the specified confidence bound(s).
}
\description{
This method computes normal-approximation confidence intervals for quantiles
and/or failure probabilities using the \code{\link{delta_method}}. The
required (log-)location-scale (and threshold) parameters and variance-covariance matrix
of these need to be estimated by Maximum Likelihood.
}
\examples{
obs   <- seq(10000, 100000, 10000)
state <- c(0, 1, 1, 0, 0, 0, 1, 0, 1, 0)
df_john <- johnson_method(x = obs, event = state)
mle <- ml_estimation(x = obs, event = state,
                     distribution = "weibull", conf_level = 0.95)
conf_fish <- confint_fisher(x = df_john$characteristic,
                            event = df_john$status,
                            loc_sc_params = mle$loc_sc_coefficients,
                            loc_sc_varcov = mle$loc_sc_vcov,
                            distribution = "weibull",
                            bounds = "two_sided",
                            conf_level = 0.95,
                            direction = "y")
}
