% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_conf}
\alias{plot_conf}
\title{Add Confidence Region(s) for Quantiles or Probabilities}
\usage{
plot_conf(p_obj, x, y, direction = c("y", "x"), distribution = c("weibull",
  "lognormal", "loglogistic"), title_trace = "Confidence Limit")
}
\arguments{
\item{p_obj}{a plotly object provided by function \code{\link{plot_mod}}.}

\item{x}{a list containing the x-coordinates of the confidence region(s).
The list can be of length 1 or 2. For more information see \strong{Details}.}

\item{y}{a list containing the y-coordinates of the Confidence Region(s).
The list can be of length 1 or 2. For more information see \strong{Details}.}

\item{direction}{a character string specifying the direction of the plotted
interval(s). Must be either "y" (failure probabilities) or "x" (quantiles).}

\item{distribution}{supposed distribution of the random variable. The
value can be \code{"weibull"}, \code{"lognormal"} or \code{"loglogistic"}.
Other distributions have not been implemented yet.}

\item{title_trace}{a character string which is assigned to the trace shown in
the legend.}
}
\value{
Returns a plotly object containing the probability plot with
  plotting positions, the estimated regression line and the estimated
  confidence region(s).
}
\description{
This function is used to add estimated confidence region(s) to an existing
probability plot which also includes the estimated regression line.
}
\details{
It is important that the length of the vectors provided as lists in \code{x}
and \code{y} match with the length of the vectors \code{x} and \code{y} in
the function \code{\link{plot_mod}}. For this reason the following procedure
is recommended:
\itemize{
  \item Calculate confidence intervals with the function
    \code{\link{confint_betabinom}} or \code{\link{confint_fisher}} and store
    it in a \code{data.frame}. For instance call it df.
  \item Inside \code{\link{plot_mod}} use the output \code{df$characteristic}
    for \code{x} and \code{df$prob} for \code{y} of the function(s) named before.
  \item In \strong{Examples} the described approach is shown with code.}
}
\examples{
obs   <- seq(10000, 100000, 10000)
state <- c(0, 1, 1, 0, 0, 0, 1, 0, 1, 0)
id <- LETTERS[1:length(obs)]

df_john <- johnson_method(x = obs, event = state, id = id)
mrr <- rank_regression(x = df_john$characteristic,
                       y = df_john$prob,
                       event = df_john$status,
                       distribution = "weibull",
                       conf_level = .95)
conf_betabin <- confint_betabinom(x = df_john$characteristic,
                                  event = df_john$status,
                                  loc_sc_params = mrr$loc_sc_coefficients,
                                  distribution = "weibull",
                                  bounds = "two_sided",
                                  conf_level = 0.95,
                                  direction = "y")

plot_weibull <- plot_prob(x = df_john$characteristic,
                          y = df_john$prob,
                          event = df_john$status,
                          id = df_john$id,
                          distribution = "weibull",
                          title_main = "Weibull Analysis",
                          title_x = "Mileage in miles",
                          title_y = "Probability of Failure",
                          title_trace = "Failed Items")
plot_reg_weibull <- plot_mod(p_obj = plot_weibull,
                             x = conf_betabin$characteristic,
                             y = conf_betabin$prob,
                             loc_sc_params = mrr$loc_sc_coefficients,
                             distribution = "weibull",
                             title_trace = "Estimated Weibull CDF")
plot_conf_beta <- plot_conf(p_obj = plot_reg_weibull,
                            x = list(conf_betabin$characteristic),
                            y = list(conf_betabin$lower_bound,
                                     conf_betabin$upper_bound),
                            direction = "y",
                            distribution = "weibull",
                            title_trace = "Confidence Region")
}
