% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findzebra.R
\name{query_fz}
\alias{query_fz}
\title{Query FindZebra for differential diagnosis generation}
\usage{
query_fz(query, num_rows = 20, fields = c("display_title", "symptom",
  "retrieved_date", "source", "score"))
}
\arguments{
\item{query}{a character vector in which each symptom is an element and
multiple words within a symptom are separated by spaces}

\item{num_rows}{maximum number of desired rare conditions}

\item{fields}{character vector containing a subset of the following:
`display_title`, `content`, `associated_gene`, `symptom`, `retrieved_date`,
`source_url`, `source`, `cui`, `score`.}
}
\value{
data frame with 1 row per rare condition and 1 column per field
(see `fields` parameter)
}
\description{
Queries the FindZebra website and returns a data frame containing properly
formatted results, including the relevant rare medical conditions and
associated genes.
}
\details{
See FindZebra API <http://www.findzebra.com/about> for more information.
}
\examples{
\dontrun{
query_fz(query = c("muscle pain", "fatigue"))
}
}
