% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation.R
\name{estimation}
\alias{estimation}
\title{Parameters estimation of a time series.}
\usage{
estimation(p = NULL, q = NULL, y, meanparam = FALSE)
}
\arguments{
\item{p}{Order of AR, if \code{NULL}, MA is computed.}

\item{q}{Order of MA, if \code{NULL}, AR is computed.}

\item{y}{Univariate time series.}

\item{meanparam}{Logical argument if the mean parameter has to be computed or not. If FALSE \eqn{\mu} is not computed.}
}
\value{
List of estimate coefficients:
\describe{
    \item{\code{mu}}{Mean parameter}.
    \item{\code{ar}}{Vector of AR coefficients with length is equal to \code{p}.}
    \item{\code{ma}}{Vector of MA coefficients with length is equal to \code{q}.}
    \item{\code{sigma.carre}}{Mean square residuals.}
}
}
\description{
Estimates the parameters of a time series for given orders \code{p} and \code{q}
}
\details{
This function uses the algorithm BFGS in the function optim to minimize our objective function \code{\link{meansq}}.
}
\examples{
y<-sim.ARMA(1000,ar = c(0.9,-0.3), ma = 0.2, method = "product")
estimation(p = 2, q = 1, y = y)

estimation(p = 1, q = 1, y = CAC40return.sq, meanparam = TRUE)

}
\references{
Francq, C. and Zakoïan, J. 1998, Estimating linear representations of nonlinear processes
\emph{Journal of Statistical Planning and Inference}, vol. 68, no. 1, pp. 145-165.
}
