% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npeaks.R
\name{npeaks}
\alias{npeaks}
\title{npeaks}
\usage{
npeaks(y, drop = c(0, 0), smooth = TRUE, threshold = 0.2)
}
\arguments{
\item{y}{is the waveform intensities.}

\item{drop}{is the index of waveform index we should ingore or non-intensity of waveform information.Default is c(0,0) that means use the all input data.}

\item{smooth}{is tell whether you want to smooth the waveform to reduce the effect of some obvious noise. Default is TRUE.}

\item{threshold}{is to determine if the detected peak is the real peak whose intensity should be higher than threshold*maximum intensity. Default is 0.2.}
}
\value{
return the number of waveform componments.
}
\description{
The function allows you to briefly know how many peaks you have in a waveform
}
\examples{

##import return waveform data
data(return)
###individual waveform
  x<-return[1,]
  npeaks(x)
  npeaks(x,smooth=FALSE) ##it will use the raw data to detect peaks
  #you can set up threshold to determine if peaks are correctly identified.
  npeaks(x,smooth=FALSE,threshold=0.25)
###if there are some columns are not intensity, you can delete before you process
   y<-c(c(1,2,3),as.numeric(x))
   npeaks(y,drop=c(1,3))

}
