% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxamp.R
\name{maxamp}
\alias{maxamp}
\title{maxamp}
\usage{
maxamp(y, smooth = TRUE, thres = 0.2, width = 3)
}
\arguments{
\item{y}{is the waveform intensities. If you have other information, you should delete these intensites before you run this function .}

\item{smooth}{is tell whether you want to smooth the waveform to reduce the effect of some obvious noise. Default is TRUE.}

\item{thres}{is to determine if the detected peak is the real peak whose intensity should be higher than threshold*maximum intensity. Default is 0.2.}

\item{width}{width of moving window.Default is 3, must be integer between 1 and n.This parameter ONLY work when the smooth is TRUE.}
}
\value{
return the largest amplitude above the ground for the waveform with more than two peaks and ground amplitude for the waveform with one peak.
}
\description{
The function allows you to find the maximum amplitude of waveform above the ground (not the whole waveform) if this waveform come from vegetation with more than 1 peaks. Otherwise it will
give the last peak's corresponding intensity. The identified maximum intensity can be used to calculate the height from waveform ending or waveform begining.
}
\examples{

data(return)
x<- return[1,]

rx<- maxamp(x)
###for more complicated waveforms
x1<- return[182,]
rx1<- maxamp(x1)
}
