% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rttestis.h.R
\name{rttestIS}
\alias{rttestIS}
\title{Robust Independent Samples T-Test}
\usage{
rttestIS(data, deps, group, yuen = TRUE, tr = 0.2, mest = FALSE,
  method = "mom", yuenbt = FALSE, nboot = 599, md = FALSE, ci = FALSE,
  es = FALSE, esci = FALSE)
}
\arguments{
\item{data}{the data as a data frame}

\item{deps}{a vector of strings naming the dependent variables in
\code{data}}

\item{group}{a string naming the grouping variable in \code{data}; must
have 2 levels}

\item{yuen}{\code{TRUE} (default) or \code{FALSE}, use the Yuen's trim
method}

\item{tr}{a number between 0 and 0.5, (default: 0.2), the proportion of
measurements to trim from each end, when using the trim and bootstrap
methods}

\item{mest}{\code{TRUE} or \code{FALSE} (default), use an M-estimator}

\item{method}{\code{'onestep'}, \code{'mom'} (default) or \code{'median'},
the M-estimator to use; One-step, Modified one-step or Median respectively}

\item{yuenbt}{\code{TRUE} or \code{FALSE} (default), use the Yuen's
bootstrap method}

\item{nboot}{a number (default: 599) specifying the number of bootstrap
samples to use when using the bootstrap method}

\item{md}{\code{TRUE} or \code{FALSE} (default), provide the mean
difference}

\item{ci}{\code{TRUE} or \code{FALSE} (default), provide a 95\% confidence
interval on the mean difference}

\item{es}{\code{TRUE} or \code{FALSE} (default), provide the effect-size}

\item{esci}{\code{TRUE} or \code{FALSE} (default), provide a 95\%
confidence interval on the effect-size}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$ttest} \tab \tab \tab \tab \tab the table of t-test results \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$ttest$asDF}

\code{as.data.frame(results$ttest)}
}
\description{
Robust Independent Samples T-Test
}
\examples{
data('eurosoccer', package='WRS2')

SpainGermany <- subset(eurosoccer, eurosoccer$League == 'Spain' | eurosoccer$League == 'Germany')
SpainGermany <- droplevels(SpainGermany)

rttestIS(SpainGermany,
         dep = 'GoalsScored',
         group = 'League',
         yuen = TRUE,
         mest = TRUE)

#
#  ROBUST INDEPENDENT SAMPLES T-TEST
#
#  Robust Independent Samples T-Test
#  ---------------------------------------------------------
#                                  t         df      p
#  ---------------------------------------------------------
#    GoalsScored    Yuen's test     0.297    17.3    0.770
#                   M-estimator    -0.933            0.993
#  ---------------------------------------------------------
#

}
