% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BackgroundSamplingFunctions.R
\name{mSampling2D}
\alias{mSampling2D}
\title{2D background sampling}
\usage{
mSampling2D(occs, rasterTemplate, mShp)
}
\arguments{
\item{occs}{A dataframe with at least two columns
named "longitude" and "latitude", or that can be
coerced into this format.}

\item{rasterTemplate}{A \verb{Raster*} object to serve
as a template for generating background sampling
coordinates.}

\item{mShp}{A shapefile defining the area from
which background points should be sampled.}
}
\value{
A \code{data.frame} with 2D coordinates of points
for background sampling.
}
\description{
Samples in 2D at resolution of raster
}
\details{
This function is designed to sample background points
for distributional modeling in two dimensions. The returned
\code{data.frame} contains all points from across the designated
background. It is up to the user to determine how to
appropriately sample from those background points.
}
\examples{
library(raster)
library(sp)

# Create sample raster
r <- raster(ncol=10, nrow=10)
values(r) <- 1:100

# Create test occurrences
set.seed(0)
longitude <- sample(extent(r)[1]:extent(r)[2],
                    size = 10, replace = FALSE)
set.seed(0)
latitude <- sample(extent(r)[3]:extent(r)[4],
                   size = 10, replace = FALSE)
occurrences <- as.data.frame(cbind(longitude,latitude))

# Generate background sampling buffer
buffPts <- SpatialPoints(occurrences[,c("longitude", "latitude")])
crs(buffPts) <- "+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs"
mShp <- buffer(buffPts, width = 1, dissolve = TRUE)

# Here's the function
result <- mSampling2D(occs = occurrences, rasterTemplate = r, mShp = mShp)

}
\keyword{backgroundSampling}
