% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markov.R
\name{staticMatrix}
\alias{staticMatrix}
\title{staticMatrix Iterate until transition probabilities converge (or give up).}
\usage{
staticMatrix(matrix, limit = 1000, digits = 4, history = F)
}
\arguments{
\item{matrix}{an adjecency matrix of trnasition probabilities}

\item{limit}{maximum number of iterations until we give up on
convergence}

\item{digits}{the number of decimal places to compare}

\item{history}{if TRUE, keep track of all matrix products}
}
\value{
a matrixseries object; that is, a list where each element
    is either the initial matrix or the product of the two
    preceding matrices
}
\description{
Compute the stationary distribution for a Markov diagram
}
\details{
Return static matrix (i.e. the stationary distribution) for the
Markov process represented by the given adjacency matrix. In the
particular case of vocaldia's, each column should roughly
correspond to the amount of time a speaker held the floor for).
Of course, not all Markov chains converge, an example being:
\preformatted{
           1
     /----->-------\
    A               B
     \----<--------/
           1

which gives

.      | 0  1 |             | 0x0+1x1  0x1+1x0|   | 1  0 |
.  M = | 1  0 |  and  M^2 = | 1x0+0x1  1x1+1x0| = | 0  1 |

}
}
\examples{
data(vocdia)
x2 <- staticMatrix(vocmatrix$ttarray, digits=4, history=TRUE)
## original matrix
round(x2[[1]],3)
## stationary matrix (M^139)
round(x2[[length(x2)]],3)
}
