% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmr-methods.R
\name{vmrInitEnv}
\alias{vmrInitEnv}
\title{Initialize the \strong{vmr} environment}
\usage{
vmrInitEnv(vmr, force.vagrantfile = FALSE, force.download = FALSE)
}
\arguments{
\item{vmr}{a \strong{vmr} object}

\item{force.vagrantfile}{if TRUE force to overwrite environment configuration (default FALSE)}

\item{force.download}{if TRUE force to download the box, otherwise do not (default FALSE).}
}
\value{
the \strong{vmr} object
}
\description{
Create \strong{vmr} environment in the current directory.
Set configuration into a template file name "Vagrantfile"
and download the box if needed.
}
\details{
The \strong{vmr} environment consist of a directory (the working directory)
and a template file name \emph{Vagrantfile}.
If the box is not present in localhost it will be download.
}
\examples{
\dontrun{
boxes <- vmrList()
vmr <- vmrCreate(boxes$Name[1])
vmr <- vmrInitEnv(vmr)
}
}
