% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxmin.R
\name{maxmin}
\alias{maxmin}
\title{Max-Min Scaling Function}
\usage{
maxmin(x)
}
\arguments{
\item{x}{Pass a vector or the required columns of a data frame through this
argument.}
}
\value{
Returns a numeric vector with the input rescaled.
}
\description{
This function allows you to scale vectors or an entire data
frame using the max-min scaling method A numeric vector is always returned.
}
\details{
This is used within \code{keymetrics_scan()} to enable row-wise
heatmapping. Originally implemented in
\url{https://github.com/martinctc/surveytoolbox}.
}
\examples{
numbers <- c(15, 40, 10, 2)
maxmin(numbers)

}
\seealso{
Other Support: 
\code{\link{camel_clean}()},
\code{\link{check_inputs}()},
\code{\link{cut_hour}()},
\code{\link{extract_date_range}()},
\code{\link{extract_hr}()},
\code{\link{heat_colours}()},
\code{\link{is_date_format}()},
\code{\link{rgb2hex}()},
\code{\link{totals_bind}()},
\code{\link{totals_col}()},
\code{\link{tstamp}()},
\code{\link{us_to_space}()},
\code{\link{wrap}()}
}
\concept{Support}
\keyword{max-min}
