% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.exp.R
\name{visualize.exp}
\alias{visualize.exp}
\title{Visualize Exponential Distribution}
\usage{
visualize.exp(stat = 1, theta = 1, section = "lower")
}
\arguments{
\item{stat}{a statistic to obtain the probability from. When using the
"bounded" condition, you must supply the parameter as \code{stat = c(lower_bound, upper_bound)}. Otherwise, a simple \code{stat = desired_point} will suffice.}

\item{theta}{vector of rates}

\item{section}{Select how you want the statistic(s) evaluated via
\code{section=} either \code{"lower"},\code{"bounded"}, \code{"upper"},
or\code{"tails"}.}
}
\value{
Returns a plot of the distribution according to the conditions
supplied.
}
\description{
Generates a plot of the Exponential distribution with user specified
parameters.
}
\examples{

# Evaluates lower tail.
visualize.exp(stat = .5, theta = 3, section = "lower")

# Evaluates bounded region.
visualize.exp(stat = c(1,2), theta = 3, section = "bounded")

# Evaluates upper tail.
visualize.exp(stat = .5, theta = 3, section = "upper")

}
\seealso{
\code{\link[=visualize.it]{visualize.it()}}, \code{\link[=dexp]{dexp()}}.
}
\author{
James Balamuta
}
\keyword{visualize}
