% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_cuminc.R
\name{estimate_cuminc}
\alias{estimate_cuminc}
\title{Competing Events Cumulative Incidence}
\usage{
estimate_cuminc(
  data = NULL,
  strata = NULL,
  CNSR = "CNSR",
  AVAL = "AVAL",
  conf.int = 0.95,
  ...
)
}
\arguments{
\item{data}{A data frame. The dataset is expected to have
one record per subject per analysis parameter. Rows with missing observations included in the analysis are removed.}

\item{AVAL, CNSR, strata}{These arguments are used to construct a formula to be passed to \code{tidycmprsk::cuminc(formula=)}.
\itemize{
\item \code{AVAL} Analysis value for Time-to-Event analysis. Default is \code{"AVAL"}, as per CDISC ADaM guiding principles.
\item \code{CNSR} Column name indicating the outcome and censoring statuses.
Column must be a factor and the first level indicates censoring, the
next level is the outcome of interest, and the remaining levels are the
competing events. Default is \code{"CNSR"}
\item \code{strata} Character vector, representing the strata for Time-to-Event analysis. When NULL, an overall analysis is performed.
Default is \code{NULL}.
}}

\item{conf.int}{Confidence internal level. Default is 0.95. Parameter is passed to \code{tidycmprsk::cuminc(conf.level=)}}

\item{...}{Additional argument passed to \code{tidycmprsk::cuminc()}}
}
\value{
A cumulative incidence object as explained at https://mskcc-epi-bio.github.io/tidycmprsk/reference/cuminc.html
}
\description{
Function creates a cumulative incidence object using the
\code{tidycmprsk::cuminc()} function.
}
\examples{
cuminc <-
  visR::estimate_cuminc(
    data = tidycmprsk::trial,
    strata = "trt",
    CNSR = "death_cr",
    AVAL = "ttdeath"
  )
cuminc

cuminc \%>\%
  visR::visr() \%>\%
  visR::add_CI() \%>\%
  visR::add_risktable(statlist = c("n.risk", "cum.event"))
}
