% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.vinereg.R
\name{predict.vinereg}
\alias{predict.vinereg}
\alias{fitted.vinereg}
\title{Predict quantiles from a D-vine regression}
\usage{
\method{predict}{vinereg}(object, newdata, alpha = 0.5, uscale = FALSE, ...)

\method{fitted}{vinereg}(object, alpha = 0.5, ...)
}
\arguments{
\item{object}{an object of class \code{vinereg}.}

\item{newdata}{matrix of covariate values for which to predict the quantile.}

\item{alpha}{vector of quantile levels.}

\item{uscale}{if \code{TRUE} input (newdata) and output is on copula scale.}

\item{...}{unused.}
}
\value{
A data.frame of quantiles where each column corresponds to one
value of \code{alpha}.
}
\description{
Predict quantiles from a D-vine regression
}
\examples{
# simulate data
x <- matrix(rnorm(300), 100, 3)
y <- x \%*\% c(1, -1, 2)
dat <- data.frame(y = y, x = x, z = as.factor(rbinom(100, 3, 0.5)))

# fit vine regression model (parametric)
fit <- vinereg(y ~ ., dat, family_set = "parametric")

# selected variables and their order in the D-vine
fit$order

# model predictions (median)
pred <- predict(fit, newdata = dat, alpha = 0.5)

# since we evaluate at the training data, this is equivalent to
pred <- fitted(fit, alpha = 0.5)

# observed vs predicted
plot(cbind(y, pred))


## fixed variable order (no selection)
fit <- vinereg(y ~ ., dat, order = c("x.3", "x.1", "x.2", "z.1"))
fit$order

}
\seealso{
\code{\link{vinereg}}
}
