% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_replicates.R
\name{read_replicates}
\alias{read_replicates}
\title{Read replicates in a directory and verify they are identical to the ones published.}
\usage{
read_replicates(
  replicates_dir,
  violation,
  replicate_nums,
  version,
  crash = TRUE
)
}
\arguments{
\item{replicates_dir}{A path to the directory containing the replicates.
Then file name of each replicate must contain at least the name of the violation
in Spanish and lower case letters (homicidio, secuestro, reclutamiento, desaparicion),
and the replicate number preceded by "R", (e.g., "R1" for replicate 1).}

\item{violation}{A string indicating the violation being analyzed. Options are
"homicidio", "secuestro", "reclutamiento", and "desaparicion".}

\item{replicate_nums}{A numeric vector containing the replicates to be analyzed.
Values in the vector should be between 1 and 100 inclusive.}

\item{version}{Version of the data being read in. Options are "v1" or "v2".
"v1" is appropriate for replicating the replicating the results of the joint
JEP-CEV-HRDAG project. "v2" is appropriate for conducting your new analyses
of the conflict in Colombia.}

\item{crash}{A parameter to define whether the function should crash if the
content of the file is not identical to the one published. If crash = TRUE
(default), it will return error and not read the data, if crash = FALSE, the
function will return a warning but still read the data.}
}
\value{
A data frame with the data from all indicated replicates.
}
\description{
Read replicates in a directory and verify they are identical to the ones published.
}
\examples{
local_dir <- system.file("extdata", "right", package = "verdata")
read_replicates(local_dir, "reclutamiento", 1, 2, version = "v1")
}
