% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_DA.R
\name{predict.vqda}
\alias{predict.vqda}
\alias{predict.vlda}
\title{predict.vqda}
\usage{
\method{predict}{vqda}(object, newdata, newerror, prior = object$prior, ...)

\method{predict}{vlda}(object, newdata, newerror, prior = object$prior, ...)
}
\arguments{
\item{object}{object of class 'vqda' or 'vlda'.}

\item{newdata}{data frame or matrix of cases to be classified or, if object has a formula, a data frame with columns of the same names as the variables used.
A vector will be interpreted as a row vector. If newdata is missing, an attempt will be made to retrieve the data used to fit the qda object.}

\item{newerror}{data frame or matrix of uncertainties corresponding to the cases in 'newdata'.}

\item{prior}{the prior probabilities of group membership. If unspecified, the prior of the object are used.}

\item{...}{...}
}
\value{
list containing the following components:
\code{class} factor containing the predicted group
\code{likelihood} matrix of dimension 'number of samples' x 'number of groups', containing the likelihood for each sample to belong to one of the groups
\code{grouping} original grouping of the samples, copied from the input object

list containing the following components:
\code{class} factor containing the predicted group
\code{likelihood} matrix of dimension 'number of samples' x 'number of groups', containing the likelihood for each sample to belong to one of the groups
\code{grouping} original grouping of the samples, copied from the input object
}
\description{
Classify multivariate observations in conjunction with qda() or lda() of class 'vqda' or 'vlda'.
}
\section{Methods (by class)}{
\itemize{
\item \code{vqda}: predict() for class 'vqda'

\item \code{vlda}: predict() for class 'vlda'
}}

\author{
Solveig Pospiech, package 'MASS'
}
