% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mat.sq.dist.R
\name{mat.sq.dist}
\alias{mat.sq.dist}
\title{Squared distance matrix}
\usage{
mat.sq.dist(Sm, dist. = "Riemannian", method = 0, pa = 0)
}
\arguments{
\item{Sm}{a (p x p x m) array of covariance matrices,
where p is the number of variables and m the number of groups.}

\item{dist.}{"Riemannian" or "Euclidean"}

\item{method}{an integer for the method of matrix inversion}

\item{pa}{an integer for the parameter of matrix inversion}
}
\value{
The matrix of squared Riemannian or Euclidean distances
}
\description{
Computes the squared distance matrix of a set of covariance matrices
}
\examples{

# Data matrix of 2D landmark coordinates
data("Tropheus")
PHEN <- as.matrix(Tropheus[which(names(Tropheus) == "X1"):which(names(Tropheus) == "Y19")])

# Procrustes superimposition
library("geomorph")
PHEN_array <- arrayspecs(PHEN, p = 19, k = 2)
phen.gpa <- gpagen(PHEN_array, print.progress = FALSE)
proc.coord <- two.d.array(phen.gpa$coords)

# Data reduction
phen.pca <- prcomp(proc.coord, rank. = 5, tol = sqrt(.Machine$double.eps))
pc.scores <- phen.pca$x

# Covariance matrix of each population
S.phen.pop <- cov.group(pc.scores, groups = Tropheus$POP.ID)

# Squared Riemannian distance matrix of the covariance matrices of all populations
eigen.phen.r <- mat.sq.dist(S.phen.pop, dist. = "Riemannian")

# Squared Euclidean distance matrix of the covariance matrices of all populations
eigen.phen.e <- mat.sq.dist(S.phen.pop, dist. = "Euclidean")

}
\seealso{
See \code{\link{minv}} for the method and the parameter used for the matrix inversion
}
