% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov.B.R
\name{cov.B}
\alias{cov.B}
\title{Between-group covariance matrix}
\usage{
cov.B(X, groups, sex = NULL, center = FALSE, weighted = FALSE)
}
\arguments{
\item{X}{a data matrix with variables in columns and group names as row names}

\item{groups}{a character / factor vector containing grouping variable}

\item{sex}{NULL (default). A character / factor vector containing sex variable,
to remove sexual dimorphism by averaging males and females in each group}

\item{center}{either a logical value or a numeric vector of length equal to the number of columns of X}

\item{weighted}{logical. Should the between-group covariance matrix be weighted?}
}
\value{
The between-group covariance matrix
}
\description{
Computes the between-group covariance matrix.
The effect of sexual dimorphism can be removed by using, for each group,
the average of the mean of males and the mean of females.
}
\examples{

# Data matrix of 2D landmark coordinates
data("Tropheus")
PHEN <- as.matrix(Tropheus[which(names(Tropheus) == "X1"):which(names(Tropheus) == "Y19")])

# Procrustes superimposition
library("geomorph")
PHEN_array <- arrayspecs(PHEN, p = 19, k = 2)
phen.gpa <- gpagen(PHEN_array, print.progress = FALSE)
proc.coord <- two.d.array(phen.gpa$coords)

# Between-group covariance matrix for all populations
B <- cov.B(proc.coord, groups = Tropheus$POP.ID)

# Between-group covariance matrix for all populations, pooled by sex
B.mf <- cov.B(proc.coord, groups = Tropheus$POP.ID, sex = Tropheus$Sex)

}
\seealso{
\code{\link[stats]{cov}}, \code{\link[stats]{cov.wt}}
}
